/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog((Class)JNDIDataSourceFactory.class);
    protected Configuration parentConfig;

    public void initializeWithParentConfiguration(Configuration conf) {
        this.parentConfig = conf;
    }

    public DataSource getDataSource(String location) throws Exception {
        try {
            return this.loadViaJNDI(location);
        }
        catch (Exception ex) {
            logger.info((Object)("failed JNDI lookup, attempt to load from local preferences. Location key:" + location));
            try {
                return this.loadFromPreferences(location);
            }
            catch (Exception preferencesException) {
                logger.info((Object)"failed loading from local preferences", Util.unwindException(preferencesException));
                QueryLogger.logConnectFailure(ex);
                throw ex;
            }
        }
    }

    DataSource loadViaJNDI(String location) throws NamingException {
        DataSource ds;
        QueryLogger.logConnect(location);
        InitialContext initCtx = new InitialContext();
        try {
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            ds = (DataSource)envCtx.lookup(location);
        }
        catch (NamingException namingEx) {
            ds = (DataSource)initCtx.lookup(location);
        }
        QueryLogger.logConnectSuccess();
        return ds;
    }

    DataSource loadFromPreferences(String location) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        DataSourceFactory prefsFactory = (DataSourceFactory)Class.forName("org.apache.cayenne.modeler.pref.PreferencesDataSourceFactory", true, loader).newInstance();
        prefsFactory.initializeWithParentConfiguration(this.parentConfig);
        return prefsFactory.getDataSource(location);
    }
}

