/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Iterator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLFromItem;
import org.apache.cayenne.ejbql.parser.EJBQLJoin;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;

class EJBQLFromTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private String lastId;

    static String makeJoinTailMarker(String id) {
        return "FROM_TAIL" + id;
    }

    EJBQLFromTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
    }

    public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex + 1 == expression.getChildrenCount() && this.lastId != null) {
            this.context.markCurrentPosition(EJBQLFromTranslator.makeJoinTailMarker(this.lastId));
        }
        return true;
    }

    public boolean visitFromItem(EJBQLFromItem expression) {
        String id = expression.getId();
        if (this.lastId != null) {
            this.context.append(',');
            this.context.markCurrentPosition(EJBQLFromTranslator.makeJoinTailMarker(this.lastId));
        }
        this.lastId = id;
        this.appendTable(id);
        return false;
    }

    public boolean visitInnerFetchJoin(EJBQLJoin join) {
        return this.visitInnerJoin(join);
    }

    public boolean visitInnerJoin(EJBQLJoin join) {
        this.appendJoin(join, "INNER JOIN");
        return false;
    }

    public boolean visitOuterFetchJoin(EJBQLJoin join) {
        return this.visitOuterJoin(join);
    }

    public boolean visitOuterJoin(EJBQLJoin join) {
        this.appendJoin(join, "LEFT OUTER JOIN");
        return false;
    }

    private void appendJoin(EJBQLJoin join, String semantics) {
        DbJoin dbJoin;
        String rhsId = join.getRightHandSideId();
        ObjRelationship joinRelationship = this.context.getCompiledExpression().getIncomingRelationship(rhsId);
        if (joinRelationship == null) {
            throw new EJBQLException("No join configured for id " + rhsId);
        }
        DbRelationship incomingDB = (DbRelationship)joinRelationship.getDbRelationships().get(0);
        String lhsId = join.getLeftHandSideId();
        String sourceAlias = this.context.getTableAlias(lhsId, incomingDB.getSourceEntity().getName());
        this.context.append(" ").append(semantics);
        String targetAlias = this.appendTable(rhsId);
        this.context.append(" ON (");
        Iterator it = incomingDB.getJoins().iterator();
        if (it.hasNext()) {
            dbJoin = (DbJoin)it.next();
            this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
        }
        while (it.hasNext()) {
            this.context.append(", ");
            dbJoin = (DbJoin)it.next();
            this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
        }
        this.context.append(")");
    }

    private String appendTable(String id) {
        ClassDescriptor descriptor = this.context.getCompiledExpression().getEntityDescriptor(id);
        String tableName = descriptor.getEntity().getDbEntity().getFullyQualifiedName();
        String alias = this.context.getTableAlias(id, tableName);
        this.context.append(' ').append(tableName).append(' ').append(alias);
        return alias;
    }
}

