/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class BindDirective
extends Directive {
    public String getName() {
        return "bind";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object value = this.getChild(context, node, 0);
        Object type = this.getChild(context, node, 1);
        Object precision = this.getChild(context, node, 2);
        int jdbcType = Integer.MAX_VALUE;
        if (type != null) {
            jdbcType = TypesMapping.getSqlTypeByName(type.toString());
        } else if (value != null) {
            jdbcType = TypesMapping.getSqlTypeByJava(value.getClass());
        }
        if (jdbcType == Integer.MAX_VALUE) {
            throw new ParseErrorException("Can't determine JDBC type of binding (" + value + ", " + type + ") at line " + node.getLine() + ", column " + node.getColumn());
        }
        ParameterBinding binding = new ParameterBinding(value, jdbcType, ConversionUtil.toInt(precision, -1));
        this.render(context, writer, binding);
        return true;
    }

    protected void render(InternalContextAdapter context, Writer writer, ParameterBinding binding) throws IOException {
        this.bind(context, binding);
        if (binding.getValue() instanceof Collection) {
            Collection bindingList = (Collection)binding.getValue();
            Iterator bindingIter = bindingList.iterator();
            while (bindingIter.hasNext()) {
                bindingIter.next();
                writer.write(63);
                if (!bindingIter.hasNext()) continue;
                writer.write(44);
            }
        } else {
            writer.write(63);
        }
    }

    protected Object getChild(InternalContextAdapter context, Node node, int i) throws MethodInvocationException {
        return i >= 0 && i < node.jjtGetNumChildren() ? node.jjtGetChild(i).value(context) : null;
    }

    protected void bind(InternalContextAdapter context, ParameterBinding binding) {
        Collection bindings = (Collection)context.getInternalUserContext().get("bindings");
        if (bindings != null) {
            if (binding.getValue() instanceof Collection) {
                Collection bindingList = (Collection)binding.getValue();
                Iterator bindingIter = bindingList.iterator();
                while (bindingIter.hasNext()) {
                    bindings.add(new ParameterBinding(bindingIter.next(), binding.getJdbcType(), binding.getPrecision()));
                }
            } else {
                bindings.add(binding);
            }
        }
    }
}

