/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.query.RelationshipQuery;

public class ToManyList
implements List,
Serializable,
ValueHolder {
    private Persistent source;
    private String relationship;
    List objectList;
    LinkedList addedToUnresolved;
    LinkedList removedFromUnresolved;

    public ToManyList(Persistent source, String relationship) {
        if (source == null) {
            throw new NullPointerException("'source' can't be null.");
        }
        if (relationship == null) {
            throw new NullPointerException("'relationship' can't be null.");
        }
        this.source = source;
        this.relationship = relationship;
        if (this.isTransientSource()) {
            this.objectList = new LinkedList();
        }
    }

    public Persistent getRelationshipOwner() {
        return this.source;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setObjectList(List objectList) {
        this.objectList = objectList;
    }

    public Object getValue() throws CayenneRuntimeException {
        return this.resolvedObjectList();
    }

    public void invalidate() {
        this.objectList = null;
    }

    public boolean isFault() {
        return this.objectList == null;
    }

    public Object getValueDirectly() throws CayenneRuntimeException {
        return this.objectList;
    }

    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        if (value == null || value instanceof List) {
            List old = this.objectList;
            this.setObjectList((List)value);
            return old;
        }
        throw new CayenneRuntimeException("Value must be a list, got: " + value.getClass().getName());
    }

    public Object setValue(Object value) throws CayenneRuntimeException {
        this.resolvedObjectList();
        return this.setValueDirectly(this.objectList);
    }

    public boolean add(Object o) {
        return this.isFault() ? this.addLocal(o) : this.objectList.add(o);
    }

    public void add(int index, Object element) {
        this.resolvedObjectList().add(index, element);
    }

    public boolean addAll(Collection c) {
        return this.resolvedObjectList().addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.resolvedObjectList().addAll(index, c);
    }

    public void clear() {
        this.resolvedObjectList().clear();
    }

    public boolean contains(Object o) {
        return this.resolvedObjectList().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.resolvedObjectList().containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ToManyList)) {
            return false;
        }
        return ((Object)this.resolvedObjectList()).equals(((ToManyList)o).resolvedObjectList());
    }

    public int hashCode() {
        return 15 + ((Object)this.resolvedObjectList()).hashCode();
    }

    public Object get(int index) {
        return this.resolvedObjectList().get(index);
    }

    public int indexOf(Object o) {
        return this.resolvedObjectList().indexOf(o);
    }

    public boolean isEmpty() {
        return this.resolvedObjectList().isEmpty();
    }

    public Iterator iterator() {
        return this.resolvedObjectList().iterator();
    }

    public int lastIndexOf(Object o) {
        return this.resolvedObjectList().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.resolvedObjectList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.resolvedObjectList().listIterator(index);
    }

    public Object remove(int index) {
        return this.resolvedObjectList().remove(index);
    }

    public boolean remove(Object o) {
        return this.isFault() ? this.removeLocal(o) : this.objectList.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.resolvedObjectList().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.resolvedObjectList().retainAll(c);
    }

    public Object set(int index, Object element) {
        return this.resolvedObjectList().set(index, element);
    }

    public int size() {
        return this.resolvedObjectList().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.resolvedObjectList().subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.resolvedObjectList().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.resolvedObjectList().toArray(a);
    }

    boolean isTransientSource() {
        int state = this.source.getPersistenceState();
        return state == 2 || state == 1;
    }

    boolean isUncommittedSource() {
        int state = this.source.getPersistenceState();
        return state == 4 || state == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List resolvedObjectList() {
        if (this.isFault()) {
            ToManyList toManyList = this;
            synchronized (toManyList) {
                if (this.isFault()) {
                    List localList = this.isTransientSource() ? new LinkedList() : this.source.getObjectContext().performQuery(new RelationshipQuery(this.source.getObjectId(), this.relationship, false));
                    this.mergeLocalChanges(localList);
                    this.objectList = localList;
                }
            }
        }
        return this.objectList;
    }

    void clearLocalChanges() {
        this.addedToUnresolved = null;
        this.removedFromUnresolved = null;
    }

    void mergeLocalChanges(List fetchedList) {
        if (this.isUncommittedSource()) {
            if (this.removedFromUnresolved != null) {
                fetchedList.removeAll(this.removedFromUnresolved);
            }
            if (this.addedToUnresolved != null && !this.addedToUnresolved.isEmpty()) {
                Iterator it = this.addedToUnresolved.iterator();
                while (it.hasNext()) {
                    Persistent dataObject;
                    Object next = it.next();
                    if (next instanceof Persistent && (dataObject = (Persistent)next).getPersistenceState() == 1 || fetchedList.contains(next)) continue;
                    fetchedList.add(next);
                }
            }
        }
        this.clearLocalChanges();
    }

    boolean addLocal(Object object) {
        if (this.removedFromUnresolved != null) {
            this.removedFromUnresolved.remove(object);
        }
        if (this.addedToUnresolved == null) {
            this.addedToUnresolved = new LinkedList();
        }
        this.addedToUnresolved.addLast(object);
        return true;
    }

    boolean removeLocal(Object object) {
        Persistent dataObject;
        if (this.addedToUnresolved != null) {
            this.addedToUnresolved.remove(object);
        }
        if (this.removedFromUnresolved == null) {
            this.removedFromUnresolved = new LinkedList();
        }
        boolean shouldAddToRemovedFromUnresolvedList = true;
        if (object instanceof Persistent && ((dataObject = (Persistent)object).getPersistenceState() == 1 || dataObject.getPersistenceState() == 2)) {
            shouldAddToRemovedFromUnresolvedList = false;
        }
        if (shouldAddToRemovedFromUnresolvedList) {
            this.removedFromUnresolved.addLast(object);
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this);
    }
}

