/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.commons.collections.Factory;

abstract class DataDomainSyncBucket {
    final Map objectsByDescriptor = new HashMap();
    final DataDomainFlushAction parent;
    List dbEntities;
    Map descriptorsByDbEntity;

    DataDomainSyncBucket(DataDomainFlushAction parent) {
        this.parent = parent;
    }

    boolean isEmpty() {
        return this.objectsByDescriptor.isEmpty();
    }

    abstract void appendQueriesInternal(Collection var1);

    void appendQueries(Collection queries) {
        if (!this.objectsByDescriptor.isEmpty()) {
            this.groupObjEntitiesBySpannedDbEntities();
            this.appendQueriesInternal(queries);
        }
    }

    void checkReadOnly(ObjEntity entity) throws CayenneRuntimeException {
        if (entity.isReadOnly()) {
            StringBuffer message = new StringBuffer();
            message.append("Attempt to modify object(s) mapped to a read-only entity: ").append(entity.getName());
            if (entity != null) {
                message.append(" '").append(entity.getName()).append("'");
            }
            message.append(". Can't commit changes.");
            throw new CayenneRuntimeException(message.toString());
        }
    }

    private void groupObjEntitiesBySpannedDbEntities() {
        this.dbEntities = new ArrayList(this.objectsByDescriptor.size());
        this.descriptorsByDbEntity = new HashMap(this.objectsByDescriptor.size() * 2);
        Iterator i = this.objectsByDescriptor.keySet().iterator();
        while (i.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)i.next();
            DbEntity dbEntity = descriptor.getEntity().getDbEntity();
            List<ClassDescriptor> objEntitiesForDbEntity = (ArrayList<ClassDescriptor>)this.descriptorsByDbEntity.get(dbEntity);
            if (objEntitiesForDbEntity == null) {
                objEntitiesForDbEntity = new ArrayList<ClassDescriptor>(1);
                this.dbEntities.add(dbEntity);
                this.descriptorsByDbEntity.put(dbEntity, objEntitiesForDbEntity);
            }
            if (!objEntitiesForDbEntity.contains(descriptor)) {
                objEntitiesForDbEntity.add(descriptor);
            }
            Iterator j = descriptor.getEntity().getAttributeMap().values().iterator();
            while (j.hasNext()) {
                ObjAttribute objAttribute;
                Object next = j.next();
                if (!(next instanceof ObjAttribute) || !(objAttribute = (ObjAttribute)next).isCompound()) continue;
                dbEntity = (DbEntity)objAttribute.getDbAttribute().getEntity();
                objEntitiesForDbEntity = (List)this.descriptorsByDbEntity.get(dbEntity);
                if (objEntitiesForDbEntity == null) {
                    objEntitiesForDbEntity = new ArrayList(1);
                    this.dbEntities.add(dbEntity);
                    this.descriptorsByDbEntity.put(dbEntity, objEntitiesForDbEntity);
                }
                if (objEntitiesForDbEntity.contains(descriptor)) continue;
                objEntitiesForDbEntity.add(descriptor);
            }
        }
    }

    void addDirtyObject(Object object, ClassDescriptor descriptor) {
        ArrayList<Object> objects = (ArrayList<Object>)this.objectsByDescriptor.get(descriptor);
        if (objects == null) {
            objects = new ArrayList<Object>();
            this.objectsByDescriptor.put(descriptor, objects);
        }
        objects.add(object);
    }

    void postprocess() {
        if (!this.objectsByDescriptor.isEmpty()) {
            CompoundDiff result = this.parent.getResultDiff();
            Map modifiedSnapshots = this.parent.getResultModifiedSnapshots();
            Collection deletedIds = this.parent.getResultDeletedIds();
            Iterator it = this.objectsByDescriptor.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ClassDescriptor descriptor = (ClassDescriptor)entry.getKey();
                Iterator objects = ((Collection)entry.getValue()).iterator();
                while (objects.hasNext()) {
                    ObjectId finalId;
                    Persistent object = (Persistent)objects.next();
                    ObjectId id = object.getObjectId();
                    if (id.isReplacementIdAttached()) {
                        Map replacement = id.getReplacementIdMap();
                        Iterator idProperties = descriptor.getIdProperties();
                        while (idProperties.hasNext()) {
                            AttributeProperty property = (AttributeProperty)idProperties.next();
                            Object value = replacement.get(property.getAttribute().getDbAttributeName());
                            if (value == null) continue;
                            property.writePropertyDirectly(object, null, value);
                        }
                        ObjectId replacementId = id.createReplacementId();
                        result.add(new NodeIdChangeOperation((Object)id, replacementId));
                        if (!id.isTemporary()) {
                            deletedIds.add(id);
                        }
                        finalId = replacementId;
                    } else {
                        if (id.isTemporary()) {
                            throw new CayenneRuntimeException("Temporary ID hasn't been replaced on commit: " + object);
                        }
                        finalId = id;
                    }
                    DataRow dataRow = this.parent.getContext().currentSnapshot(object);
                    if (object instanceof DataObject) {
                        DataObject dataObject = (DataObject)object;
                        dataRow.setReplacesVersion(dataObject.getSnapshotVersion());
                        dataObject.setSnapshotVersion(dataRow.getVersion());
                    }
                    modifiedSnapshots.put(finalId, dataRow);
                }
            }
        }
    }

    static final class PropagatedValueFactory
    implements Factory {
        ObjectId masterID;
        String masterKey;

        PropagatedValueFactory(ObjectId masterID, String masterKey) {
            this.masterID = masterID;
            this.masterKey = masterKey;
        }

        public Object create() {
            Object value = this.masterID.getIdSnapshot().get(this.masterKey);
            if (value == null) {
                throw new CayenneRuntimeException("Can't extract a master key. Missing key (" + this.masterKey + "), master ID (" + this.masterID + ")");
            }
            return value;
        }
    }
}

