/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.Property;

public abstract class BaseContext
implements ObjectContext {
    protected transient DataChannel channel;

    public abstract void commitChanges();

    public abstract void commitChangesToParent();

    public abstract void deleteObject(Object var1) throws DeleteDenyException;

    public abstract Collection deletedObjects();

    public DataChannel getChannel() {
        return this.channel;
    }

    public abstract EntityResolver getEntityResolver();

    public abstract GraphManager getGraphManager();

    public abstract Persistent localObject(ObjectId var1, Object var2);

    public abstract Collection modifiedObjects();

    public abstract Persistent newObject(Class var1);

    public abstract void registerNewObject(Object var1);

    public abstract Collection newObjects();

    public abstract QueryResponse performGenericQuery(Query var1);

    public abstract List performQuery(Query var1);

    public void prepareForAccess(Persistent object, String property) {
        this.prepareForAccess(object, property, false);
    }

    public void prepareForAccess(Persistent object, String property, boolean lazyFaulting) {
        if (object.getPersistenceState() == 5) {
            ObjectId oid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(oid, false, 1));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for ObjectId: " + oid);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for ObjectId: " + oid);
            }
            if (object.getPersistenceState() != 3) {
                String state = PersistenceState.persistenceStateName(object.getPersistenceState());
                throw new FaultFailureException("Error resolving fault for ObjectId: " + oid + " and state (" + state + "). Possible cause - matching row is missing from the database.");
            }
        }
        if (lazyFaulting && property != null) {
            Property propertyDescriptor = this.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName()).getProperty(property);
            propertyDescriptor.readProperty(object);
        }
    }

    public abstract void propertyChanged(Persistent var1, String var2, Object var3, Object var4);

    public abstract void rollbackChanges();

    public abstract void rollbackChangesLocally();

    public abstract Collection uncommittedObjects();
}

