/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/

package org.apache.cayenne.remote.hessian.service;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import org.apache.cayenne.DataRow;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;

/**
 * A server-side DataRow Hessian serializer.
 * 
 * @author Andrus Adamchik
 */
class ServerDataRowSerializer extends AbstractSerializer {

    public void writeObject(Object object, AbstractHessianOutput out) throws IOException {
        if (out.addRef(object)) {
            return;
        }

        DataRow row = (DataRow) object;

        out.writeMapBegin(DataRow.class.getName());
        
        out.writeInt(row.size());
        out.writeLong(row.getVersion());
        out.writeLong(row.getReplacesVersion());

        Iterator it = row.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }

        out.writeMapEnd();
    }

}
