/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBatchQuery
extends BatchQuery {
    protected List<Map> qualifierSnapshots;
    protected List<DbAttribute> dbAttributes;
    protected boolean usingOptimisticLocking;
    private Collection<DbAttribute> qualifierAttributes;
    private Collection<String> nullQualifierNames;

    public DeleteBatchQuery(DbEntity dbEntity, int batchCapacity) {
        this(dbEntity, dbEntity.getPrimaryKeys(), Collections.EMPTY_SET, batchCapacity);
    }

    public DeleteBatchQuery(DbEntity dbEntity, Collection<DbAttribute> qualifierAttributes, Collection<String> nullQualifierNames, int batchCapacity) {
        super(dbEntity);
        this.qualifierAttributes = qualifierAttributes;
        this.nullQualifierNames = nullQualifierNames != null ? nullQualifierNames : Collections.EMPTY_SET;
        this.qualifierSnapshots = new ArrayList<Map>(batchCapacity);
        this.dbAttributes = new ArrayList<DbAttribute>(qualifierAttributes.size());
        this.dbAttributes.addAll(qualifierAttributes);
        this.batchIndex = -1;
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    @Override
    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    public Collection<DbAttribute> getQualifierAttributes() {
        return this.qualifierAttributes;
    }

    @Override
    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = this.dbAttributes.get(dbAttributeIndex);
        return this.getCurrentQualifier().get(attribute.getName());
    }

    public void add(Map dataObjectId) {
        this.qualifierSnapshots.add(dataObjectId);
    }

    @Override
    public int size() {
        return this.qualifierSnapshots.size();
    }

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.dbAttributes;
    }

    public Map getCurrentQualifier() {
        return this.qualifierSnapshots.get(this.batchIndex);
    }
}

