/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectResolver {
    DataContext context;
    ClassDescriptor descriptor;
    Collection<DbAttribute> primaryKey;
    boolean refreshObjects;
    DataRowStore cache;
    DescriptorResolutionStrategy descriptorResolutionStrategy;

    ObjectResolver(DataContext context, ClassDescriptor descriptor, boolean refresh) {
        DbEntity dbEntity = descriptor.getEntity().getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("ObjEntity '" + descriptor.getEntity().getName() + "' has no DbEntity.");
        }
        this.primaryKey = dbEntity.getPrimaryKeys();
        if (this.primaryKey.size() == 0) {
            throw new CayenneRuntimeException("Won't be able to create ObjectId for '" + descriptor.getEntity().getName() + "'. Reason: DbEntity '" + dbEntity.getName() + "' has no Primary Key defined.");
        }
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
        this.refreshObjects = refresh;
        this.descriptor = descriptor;
        EntityInheritanceTree inheritanceTree = context.getEntityResolver().lookupInheritanceTree(descriptor.getEntity());
        this.descriptorResolutionStrategy = inheritanceTree != null ? new InheritanceStrategy() : new NoInheritanceStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Persistent> synchronizedObjectsFromDataRows(List<? extends DataRow> rows) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            return this.objectsFromDataRows(rows);
        }
    }

    List<Persistent> objectsFromDataRows(List<? extends DataRow> rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList<Persistent>(1);
        }
        ArrayList<Persistent> results = new ArrayList<Persistent>(rows.size());
        for (DataRow dataRow : rows) {
            results.add(this.objectFromDataRow(dataRow));
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    Persistent objectFromDataRow(DataRow row) {
        ClassDescriptor classDescriptor = this.descriptorResolutionStrategy.descriptorForRow(row);
        ObjectId anId = this.createObjectId(row, classDescriptor.getEntity(), null);
        return this.objectFromDataRow(row, anId, classDescriptor);
    }

    Persistent objectFromDataRow(DataRow row, ObjectId anId, ClassDescriptor classDescriptor) {
        if (anId == null) {
            return null;
        }
        Persistent object = this.context.localObject(anId, null);
        int state = object.getPersistenceState();
        switch (state) {
            case 3: 
            case 4: 
            case 6: {
                if (!this.refreshObjects) break;
                DataRowUtils.mergeObjectWithSnapshot(this.context, classDescriptor, object, row);
                if (!(object instanceof DataObject)) break;
                ((DataObject)object).setSnapshotVersion(row.getVersion());
                break;
            }
            case 5: {
                DataRow cachedRow;
                if (!this.refreshObjects && (cachedRow = this.cache.getCachedSnapshot(anId)) != null) {
                    row = cachedRow;
                }
                DataRowUtils.mergeObjectWithSnapshot(this.context, classDescriptor, object, row);
                if (!(object instanceof DataObject)) break;
                ((DataObject)object).setSnapshotVersion(row.getVersion());
                break;
            }
        }
        return object;
    }

    ObjEntity getEntity() {
        return this.descriptor.getEntity();
    }

    ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    EntityResolver getEntityResolver() {
        return this.context.getEntityResolver();
    }

    ObjectContext getContext() {
        return this.context;
    }

    ObjectId createObjectId(DataRow dataRow, ObjEntity objEntity, String namePrefix) {
        boolean prefix;
        Collection<DbAttribute> pk = objEntity == this.descriptor.getEntity() ? this.primaryKey : objEntity.getDbEntity().getPrimaryKeys();
        boolean bl = prefix = namePrefix != null && namePrefix.length() > 0;
        if (pk.size() == 1) {
            DbAttribute attribute = pk.iterator().next();
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                return null;
            }
            return new ObjectId(objEntity.getName(), attribute.getName(), val);
        }
        HashMap idMap = new HashMap(pk.size() * 2);
        for (DbAttribute attribute : pk) {
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                return null;
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(objEntity.getName(), idMap);
    }

    class InheritanceStrategy
    implements DescriptorResolutionStrategy {
        InheritanceStrategy() {
        }

        public final ClassDescriptor descriptorForRow(DataRow row) {
            String entityName = row.getEntityName();
            return entityName != null ? ObjectResolver.this.context.getEntityResolver().getClassDescriptor(entityName) : ObjectResolver.this.descriptor;
        }
    }

    class NoInheritanceStrategy
    implements DescriptorResolutionStrategy {
        NoInheritanceStrategy() {
        }

        public final ClassDescriptor descriptorForRow(DataRow row) {
            return ObjectResolver.this.descriptor;
        }
    }

    static interface DescriptorResolutionStrategy {
        public ClassDescriptor descriptorForRow(DataRow var1);
    }
}

