/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainInsertQuery;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDomainInsertBucket
extends DataDomainSyncBucket {
    DataDomainInsertBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    @Override
    void appendQueriesInternal(Collection<Query> queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, false);
        for (DbEntity dbEntity : this.dbEntities) {
            Collection descriptors = (Collection)this.descriptorsByDbEntity.get(dbEntity);
            DataDomainInsertQuery batch = new DataDomainInsertQuery(this.parent.getDomain(), dbEntity, 27);
            for (DbEntityClassDescriptor descriptor : descriptors) {
                diffBuilder.reset(descriptor);
                List objects = (List)this.objectsByDescriptor.get(descriptor.getClassDescriptor());
                if (objects.isEmpty()) continue;
                this.checkReadOnly(descriptor.getEntity());
                this.createPermIds(descriptor, objects);
                sorter.sortObjectsForEntity(descriptor.getEntity(), objects, false);
                for (Persistent o : objects) {
                    Map<Object, Object> snapshot = diffBuilder.buildDBDiff(this.parent.objectDiff(o.getObjectId()));
                    batch.add(snapshot, o.getObjectId());
                }
            }
            queries.add(batch);
        }
    }

    void createPermIds(DbEntityClassDescriptor descriptor, Collection<Persistent> objects) {
        if (objects.isEmpty()) {
            return;
        }
        ObjEntity objEntity = descriptor.getEntity();
        DbEntity entity = descriptor.getDbEntity();
        DataNode node = this.parent.getDomain().lookupDataNode(entity.getDataMap());
        boolean supportsGeneratedKeys = node.getAdapter().supportsGeneratedKeys();
        PkGenerator pkGenerator = node.getAdapter().getPkGenerator();
        for (Persistent object : objects) {
            ObjectId id = object.getObjectId();
            if (id == null || !id.isTemporary()) continue;
            Map<String, Object> idMap = id.getReplacementIdMap();
            boolean autoPkDone = false;
            for (DbAttribute dbAttr : entity.getPrimaryKeys()) {
                Class<?> javaClass;
                Object value;
                String dbAttrName = dbAttr.getName();
                if (idMap.containsKey(dbAttrName)) continue;
                ObjAttribute objAttr = objEntity.getAttributeForDbAttribute(dbAttr);
                if (!(objAttr == null || (value = descriptor.getClassDescriptor().getProperty(objAttr.getName()).readPropertyDirectly(object)) == null || (javaClass = objAttr.getJavaClass()).isPrimitive() && value instanceof Number && ((Number)value).intValue() == 0)) {
                    idMap.put(dbAttrName, value);
                    continue;
                }
                if (supportsGeneratedKeys && dbAttr.isGenerated() || this.isPropagated(dbAttr)) continue;
                if (autoPkDone) {
                    throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.");
                }
                try {
                    Object pkValue = pkGenerator.generatePk(node, dbAttr);
                    idMap.put(dbAttrName, pkValue);
                    autoPkDone = true;
                }
                catch (Exception ex) {
                    throw new CayenneRuntimeException("Error generating PK: " + ex.getMessage(), ex);
                }
            }
        }
    }

    boolean isPropagated(DbAttribute attribute) {
        for (DbRelationship dbRelationship : attribute.getEntity().getRelationships()) {
            if (!dbRelationship.isToMasterPK()) continue;
            for (DbJoin join : dbRelationship.getJoins()) {
                if (!attribute.getName().equals(join.getSourceName())) continue;
                return true;
            }
        }
        return false;
    }
}

