/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnComponentRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnComponentLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultRelation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultColumnComponentRelationBuilder
implements ColumnComponentRelationBuilder<Relation> {
    private final CqlIdentifier columnId;
    private final Term index;

    public DefaultColumnComponentRelationBuilder(@NonNull CqlIdentifier columnId, @NonNull Term index) {
        this.columnId = columnId;
        this.index = index;
    }

    @Override
    @NonNull
    public Relation build(@NonNull String operator, @Nullable Term rightOperand) {
        return new DefaultRelation(new ColumnComponentLeftOperand(this.columnId, this.index), operator, rightOperand);
    }

    @Immutable
    public static class Fluent<StatementT extends OngoingWhereClause<StatementT>>
    implements ColumnComponentRelationBuilder<StatementT> {
        private final OngoingWhereClause<StatementT> statement;
        private final ColumnComponentRelationBuilder<Relation> delegate;

        public Fluent(@NonNull OngoingWhereClause<StatementT> statement, @NonNull CqlIdentifier columnId, @NonNull Term index) {
            this.statement = statement;
            this.delegate = new DefaultColumnComponentRelationBuilder(columnId, index);
        }

        @Override
        @NonNull
        public StatementT build(@NonNull String operator, @Nullable Term rightOperand) {
            return this.statement.where((Relation)this.delegate.build(operator, rightOperand));
        }
    }
}

