/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spring.boot.actuate.endpoint.CamelRoutesEndpointProperties;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.lang.Nullable;

@Endpoint(id="camelroutes")
public class CamelRoutesEndpoint {
    private CamelContext camelContext;
    private ManagedCamelContext managedCamelContext;
    private CamelRoutesEndpointProperties properties;

    public CamelRoutesEndpoint(CamelContext camelContext, CamelRoutesEndpointProperties properties) {
        this.camelContext = camelContext;
        this.managedCamelContext = (ManagedCamelContext)camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        this.properties = properties;
    }

    @ReadOperation
    public List<RouteEndpointInfo> readRoutes() {
        return this.getRoutesInfo();
    }

    @ReadOperation
    public Object doReadAction(@Selector String id, @Selector ReadAction action) {
        switch (action.ordinal()) {
            case 0: {
                return this.getRouteDetailsInfo(id);
            }
            case 1: {
                return this.getRouteInfo(id);
            }
        }
        throw new IllegalArgumentException("Unsupported read action " + String.valueOf((Object)action));
    }

    @WriteOperation
    public void doWriteAction(@Selector String id, @Selector WriteAction action, @Nullable TimeInfo timeInfo) {
        if (this.properties.isReadOnly()) {
            throw new IllegalArgumentException(String.format("Read only: write action %s is not allowed", new Object[]{action}));
        }
        switch (action.ordinal()) {
            case 0: {
                this.stopRoute(id, Optional.ofNullable(timeInfo).flatMap(ti -> Optional.ofNullable(ti.getTimeout())), Optional.of(TimeUnit.SECONDS), Optional.ofNullable(timeInfo).flatMap(ti -> Optional.ofNullable(ti.getAbortAfterTimeout())));
                break;
            }
            case 1: {
                this.startRoute(id);
                break;
            }
            case 2: {
                this.resetRoute(id);
                break;
            }
            case 3: {
                this.suspendRoute(id, Optional.ofNullable(timeInfo).flatMap(ti -> Optional.ofNullable(ti.getTimeout())), Optional.of(TimeUnit.SECONDS));
                break;
            }
            case 4: {
                this.resumeRoute(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported write action " + String.valueOf((Object)action));
            }
        }
    }

    private RouteEndpointInfo getRouteInfo(String id) {
        Route route = this.camelContext.getRoute(id);
        if (route != null) {
            return new RouteEndpointInfo(route);
        }
        return null;
    }

    private List<RouteEndpointInfo> getRoutesInfo() {
        return this.camelContext.getRoutes().stream().map(RouteEndpointInfo::new).collect(Collectors.toList());
    }

    private RouteDetailsEndpointInfo getRouteDetailsInfo(String id) {
        Route route = this.camelContext.getRoute(id);
        if (route != null) {
            return new RouteDetailsEndpointInfo(this.camelContext, route);
        }
        return null;
    }

    private void startRoute(String id) {
        try {
            this.camelContext.getRouteController().startRoute(id);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private void resetRoute(String id) {
        try {
            ManagedRouteMBean managedRouteMBean = this.managedCamelContext.getManagedRoute(id, ManagedRouteMBean.class);
            if (managedRouteMBean != null) {
                managedRouteMBean.reset(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private void stopRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit, Optional<Boolean> abortAfterTimeout) {
        try {
            if (timeout.isPresent()) {
                this.camelContext.getRouteController().stopRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS), abortAfterTimeout.orElse(Boolean.TRUE).booleanValue());
            } else {
                this.camelContext.getRouteController().stopRoute(id);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private void suspendRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit) {
        try {
            if (timeout.isPresent()) {
                this.camelContext.getRouteController().suspendRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS));
            } else {
                this.camelContext.getRouteController().suspendRoute(id);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private void resumeRoute(String id) {
        try {
            this.camelContext.getRouteController().resumeRoute(id);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static enum ReadAction {
        DETAIL,
        INFO;

    }

    public static class RouteDetailsEndpointInfo
    extends RouteEndpointInfo {
        @JsonProperty(value="details")
        private RouteDetails routeDetails;

        public RouteDetailsEndpointInfo(CamelContext camelContext, Route route) {
            super(route);
            if (camelContext.getManagementStrategy().getManagementAgent() != null) {
                ManagedCamelContext mcc = (ManagedCamelContext)camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
                this.routeDetails = new RouteDetails(mcc.getManagedRoute(route.getId(), ManagedRouteMBean.class));
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        static class RouteDetails {
            private long deltaProcessingTime;
            private long exchangesInflight;
            private long exchangesTotal;
            private long externalRedeliveries;
            private long failuresHandled;
            private String firstExchangeCompletedExchangeId;
            private Date firstExchangeCompletedTimestamp;
            private String firstExchangeFailureExchangeId;
            private Date firstExchangeFailureTimestamp;
            private String lastExchangeCompletedExchangeId;
            private Date lastExchangeCompletedTimestamp;
            private String lastExchangeFailureExchangeId;
            private Date lastExchangeFailureTimestamp;
            private long lastProcessingTime;
            private String load01;
            private String load05;
            private String load15;
            private long maxProcessingTime;
            private long meanProcessingTime;
            private long minProcessingTime;
            private Long oldestInflightDuration;
            private String oldestInflightExchangeId;
            private long redeliveries;
            private long totalProcessingTime;
            private boolean hasRouteController;

            RouteDetails(ManagedRouteMBean managedRoute) {
                try {
                    this.deltaProcessingTime = managedRoute.getDeltaProcessingTime();
                    this.exchangesInflight = managedRoute.getExchangesInflight();
                    this.exchangesTotal = managedRoute.getExchangesTotal();
                    this.externalRedeliveries = managedRoute.getExternalRedeliveries();
                    this.failuresHandled = managedRoute.getFailuresHandled();
                    this.firstExchangeCompletedExchangeId = managedRoute.getFirstExchangeCompletedExchangeId();
                    this.firstExchangeCompletedTimestamp = managedRoute.getFirstExchangeCompletedTimestamp();
                    this.firstExchangeFailureExchangeId = managedRoute.getFirstExchangeFailureExchangeId();
                    this.firstExchangeFailureTimestamp = managedRoute.getFirstExchangeFailureTimestamp();
                    this.lastExchangeCompletedExchangeId = managedRoute.getLastExchangeCompletedExchangeId();
                    this.lastExchangeCompletedTimestamp = managedRoute.getLastExchangeCompletedTimestamp();
                    this.lastExchangeFailureExchangeId = managedRoute.getLastExchangeFailureExchangeId();
                    this.lastExchangeFailureTimestamp = managedRoute.getLastExchangeFailureTimestamp();
                    this.lastProcessingTime = managedRoute.getLastProcessingTime();
                    this.load01 = managedRoute.getLoad01();
                    this.load05 = managedRoute.getLoad05();
                    this.load15 = managedRoute.getLoad15();
                    this.maxProcessingTime = managedRoute.getMaxProcessingTime();
                    this.meanProcessingTime = managedRoute.getMeanProcessingTime();
                    this.minProcessingTime = managedRoute.getMinProcessingTime();
                    this.oldestInflightDuration = managedRoute.getOldestInflightDuration();
                    this.oldestInflightExchangeId = managedRoute.getOldestInflightExchangeId();
                    this.redeliveries = managedRoute.getRedeliveries();
                    this.totalProcessingTime = managedRoute.getTotalProcessingTime();
                    this.hasRouteController = managedRoute.getHasRouteController();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public long getDeltaProcessingTime() {
                return this.deltaProcessingTime;
            }

            public long getExchangesInflight() {
                return this.exchangesInflight;
            }

            public long getExchangesTotal() {
                return this.exchangesTotal;
            }

            public long getExternalRedeliveries() {
                return this.externalRedeliveries;
            }

            public long getFailuresHandled() {
                return this.failuresHandled;
            }

            public String getFirstExchangeCompletedExchangeId() {
                return this.firstExchangeCompletedExchangeId;
            }

            public Date getFirstExchangeCompletedTimestamp() {
                return this.firstExchangeCompletedTimestamp;
            }

            public String getFirstExchangeFailureExchangeId() {
                return this.firstExchangeFailureExchangeId;
            }

            public Date getFirstExchangeFailureTimestamp() {
                return this.firstExchangeFailureTimestamp;
            }

            public String getLastExchangeCompletedExchangeId() {
                return this.lastExchangeCompletedExchangeId;
            }

            public Date getLastExchangeCompletedTimestamp() {
                return this.lastExchangeCompletedTimestamp;
            }

            public String getLastExchangeFailureExchangeId() {
                return this.lastExchangeFailureExchangeId;
            }

            public Date getLastExchangeFailureTimestamp() {
                return this.lastExchangeFailureTimestamp;
            }

            public long getLastProcessingTime() {
                return this.lastProcessingTime;
            }

            public String getLoad01() {
                return this.load01;
            }

            public String getLoad05() {
                return this.load05;
            }

            public String getLoad15() {
                return this.load15;
            }

            public long getMaxProcessingTime() {
                return this.maxProcessingTime;
            }

            public long getMeanProcessingTime() {
                return this.meanProcessingTime;
            }

            public long getMinProcessingTime() {
                return this.minProcessingTime;
            }

            public Long getOldestInflightDuration() {
                return this.oldestInflightDuration;
            }

            public String getOldestInflightExchangeId() {
                return this.oldestInflightExchangeId;
            }

            public long getRedeliveries() {
                return this.redeliveries;
            }

            public long getTotalProcessingTime() {
                return this.totalProcessingTime;
            }

            public boolean getHasRouteController() {
                return this.hasRouteController;
            }
        }
    }

    @JsonPropertyOrder(value={"id", "group", "description", "uptime", "uptimeMillis"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class RouteEndpointInfo {
        private final String id;
        private final String group;
        private final Map<String, Object> properties;
        private final String description;
        private final String uptime;
        private final long uptimeMillis;
        private final String status;

        public RouteEndpointInfo(Route route) {
            this.id = route.getId();
            this.group = route.getGroup();
            this.description = route.getDescription();
            this.uptime = route.getUptime();
            this.uptimeMillis = route.getUptimeMillis();
            this.properties = route.getProperties() != null ? new HashMap<String, Object>(route.getProperties()) : Collections.emptyMap();
            this.status = route instanceof StatefulService ? ((StatefulService)route).getStatus().name() : null;
        }

        public String getId() {
            return this.id;
        }

        public String getGroup() {
            return this.group;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUptime() {
            return this.uptime;
        }

        public long getUptimeMillis() {
            return this.uptimeMillis;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static enum WriteAction {
        STOP,
        START,
        RESET,
        SUSPEND,
        RESUME;

    }

    public static class TimeInfo {
        private Long timeout;
        private Boolean abortAfterTimeout;

        public Long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public Boolean getAbortAfterTimeout() {
            return this.abortAfterTimeout;
        }

        public void setAbortAfterTimeout(Boolean abortAfterTimeout) {
            this.abortAfterTimeout = abortAfterTimeout;
        }
    }
}

