/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.apache.camel.CamelContext;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.springframework.context.ApplicationContext;

public class CamelMainRunController {
    private final CamelSpringBootApplicationController controller;
    private final Thread daemon;

    public CamelMainRunController(ApplicationContext applicationContext, CamelContext camelContext) {
        this.controller = new CamelSpringBootApplicationController(applicationContext, camelContext);
        this.daemon = new Thread((Runnable)new DaemonTask(), "CamelMainRunController");
    }

    public void start() {
        if (!this.daemon.isAlive()) {
            this.daemon.start();
        }
    }

    public MainShutdownStrategy getMainShutdownStrategy() {
        return this.controller.getMainShutdownStrategy();
    }

    public Runnable getMainCompleteTask() {
        return this.controller.getMainCompletedTask();
    }

    private final class DaemonTask
    implements Runnable {
        private DaemonTask() {
        }

        @Override
        public void run() {
            CamelMainRunController.this.controller.run();
        }
    }
}

