/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.console;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.util.json.JsonObject;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="camel")
public class CamelDevConsoleEndpoint {
    private CamelContext camelContext;

    public CamelDevConsoleEndpoint(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ReadOperation
    public JsonObject getConsoles() {
        DevConsoleRegistry dcr = (DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
        if (dcr == null || !dcr.isEnabled()) {
            return null;
        }
        JsonObject root = new JsonObject();
        dcr.stream().forEach(c -> {
            JsonObject jo = new JsonObject();
            jo.put((Object)"id", (Object)c.getId());
            jo.put((Object)"displayName", (Object)c.getDisplayName());
            jo.put((Object)"description", (Object)c.getDescription());
            root.put((Object)c.getId(), (Object)jo);
        });
        return root;
    }

    @ReadOperation
    public JsonObject getConsoleById(@Selector String id) {
        DevConsoleRegistry dcr = (DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
        if (dcr == null || !dcr.isEnabled()) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CamelHttpPath", id);
        JsonObject root = new JsonObject();
        dcr.stream().sorted((o1, o2) -> {
            int p1 = id.indexOf(o1.getId());
            int p2 = id.indexOf(o2.getId());
            return Integer.compare(p1, p2);
        }).forEach(c -> {
            Object out;
            boolean include;
            boolean bl = include = "all".equals(id) || id.contains(c.getId());
            if (include && c.supportMediaType(DevConsole.MediaType.JSON) && (out = c.call(DevConsole.MediaType.JSON, params)) != null) {
                root.put((Object)c.getId(), out);
            }
        });
        return root;
    }
}

