/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class CamelVirtualThreadEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelVirtualThreadEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String springVirtualThreads = environment.getProperty("spring.threads.virtual.enabled");
        if ("true".equalsIgnoreCase(springVirtualThreads)) {
            String existingCamelProperty = System.getProperty("camel.threads.virtual.enabled");
            if (existingCamelProperty == null) {
                System.setProperty("camel.threads.virtual.enabled", "true");
                LOG.info("Spring virtual threads enabled - automatically setting camel.threads.virtual.enabled=true");
            } else {
                LOG.debug("camel.threads.virtual.enabled already set to: {}", (Object)existingCamelProperty);
            }
        }
    }
}

