/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextEvents;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.clock.Clock;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.DebuggerConfigurationProperties;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.Model;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.spi.StartupConditionStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.CamelSpringBootApplicationListener;
import org.apache.camel.spring.boot.CamelSpringBootBeanPostProcessor;
import org.apache.camel.spring.boot.CamelSpringBootRoutesCollector;
import org.apache.camel.spring.boot.CamelStartupConditionConfigurationProperties;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.FatJarPackageScanResourceResolver;
import org.apache.camel.spring.boot.FilePropertySource;
import org.apache.camel.spring.boot.PropertiesComponentConfiguration;
import org.apache.camel.spring.boot.SpringBootCamelContext;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.apache.camel.spring.boot.aot.CamelRuntimeHints;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.CamelBeanPostProcessor;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.ResetableClock;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.DefaultStartupConditionStrategy;
import org.apache.camel.support.startup.EnvStartupCondition;
import org.apache.camel.support.startup.FileStartupCondition;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@ImportRuntimeHints(value={CamelRuntimeHints.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CamelConfigurationProperties.class, CamelStartupConditionConfigurationProperties.class, PropertiesComponentConfiguration.class})
@Import(value={TypeConversionConfiguration.class})
@Role(value=2)
public class CamelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoConfiguration.class);

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config, CamelBeanPostProcessor beanPostProcessor, StartupConditionStrategy startup) throws Exception {
        ResetableClock clock = new ResetableClock();
        CamelSpringBootApplicationController controller = new CamelSpringBootApplicationController(applicationContext);
        SpringBootCamelContext camelContext = new SpringBootCamelContext(applicationContext, config.getMain().isWarnOnEarlyShutdown(), controller);
        camelContext.getClock().add((Enum)ContextEvents.BOOT, (Clock)clock);
        controller.setCamelContext((CamelContext)camelContext);
        beanPostProcessor.setCamelContext((CamelContext)camelContext);
        camelContext.getCamelContextExtension().addContextPlugin(CamelBeanPostProcessor.class, (Object)beanPostProcessor);
        camelContext.getCamelContextExtension().addContextPlugin(StartupConditionStrategy.class, (Object)startup);
        return CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config, controller);
    }

    public static CamelContext doConfigureCamelContext(ApplicationContext applicationContext, CamelContext camelContext, CamelConfigurationProperties config, CamelSpringBootApplicationController controller) throws Exception {
        ConfigurableEnvironment cev;
        Map<String, String> vars;
        MutablePropertySources sources;
        Environment env;
        Map repositories;
        org.apache.camel.component.properties.PropertiesComponent pc;
        CamelContextAware.trySetCamelContext((Object)controller, (CamelContext)camelContext);
        CamelAutoConfiguration.configureStartupRecorder(camelContext, config);
        camelContext.build();
        List listeners = controller.getMain().getMainListeners();
        if (!listeners.isEmpty()) {
            for (MainListener listener : listeners) {
                listener.beforeInitialize((BaseMainSupport)controller.getMain());
            }
            for (MainListener listener : listeners) {
                listener.beforeConfigure((BaseMainSupport)controller.getMain());
            }
        }
        if ((pc = (org.apache.camel.component.properties.PropertiesComponent)applicationContext.getBeanProvider(org.apache.camel.component.properties.PropertiesComponent.class).getIfAvailable()) != null) {
            pc.setCamelContext(camelContext);
            camelContext.setPropertiesComponent((PropertiesComponent)pc);
        }
        if (!(repositories = applicationContext.getBeansOfType(BeanRepository.class)).isEmpty()) {
            ArrayList<Object> reps = new ArrayList<Object>();
            reps.add(new ApplicationContextBeanRepository(applicationContext));
            reps.addAll(repositories.values());
            OrderComparator.sort(reps);
            camelContext.getCamelContextExtension().setRegistry((Registry)new DefaultRegistry(reps));
        }
        if (ObjectHelper.isNotEmpty((String)config.getMain().getFileConfigurations()) && (env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && !(sources = ((ConfigurableEnvironment)env).getPropertySources()).contains("camel-file-configuration")) {
            sources.addFirst((PropertySource)new FilePropertySource("camel-file-configuration", applicationContext, config.getMain().getFileConfigurations()));
        }
        if ((env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && !(vars = CamelAutoConfiguration.doExtractVariablesFromSpringBoot(cev = (ConfigurableEnvironment)env)).isEmpty()) {
            for (String key : vars.keySet()) {
                String value = vars.get(key);
                String id = StringHelper.before((String)key, (String)":", (String)"global");
                key = StringHelper.after((String)key, (String)":", (String)key);
                VariableRepository repo = ((VariableRepositoryFactory)camelContext.getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class)).getVariableRepository(id);
                if (value.startsWith("resource:") && ResourceHelper.hasScheme((String)(value = value.substring(9)))) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)value);
                    value = IOHelper.loadText((InputStream)is);
                    IOHelper.close((Closeable)is);
                }
                repo.setVariable(key, (Object)value);
            }
        }
        CamelAutoConfiguration.configureDebugger(applicationContext, camelContext);
        CamelAutoConfiguration.configureCliConnector(applicationContext, camelContext);
        camelContext.getCamelContextExtension().addContextPlugin(PackageScanClassResolver.class, (Object)new FatJarPackageScanClassResolver());
        camelContext.getCamelContextExtension().addContextPlugin(PackageScanResourceResolver.class, (Object)new FatJarPackageScanResourceResolver());
        if (config.getMain().getRouteFilterIncludePattern() != null || config.getMain().getRouteFilterExcludePattern() != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)config.getMain().getRouteFilterIncludePattern(), (Object)config.getMain().getRouteFilterExcludePattern());
            ((Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(config.getMain().getRouteFilterIncludePattern(), config.getMain().getRouteFilterExcludePattern());
        }
        DefaultConfigurationConfigurer.configure((CamelContext)camelContext, (DefaultConfigurationProperties)config.getMain());
        DefaultConfigurationConfigurer.afterConfigure((CamelContext)camelContext);
        DefaultConfigurationConfigurer.afterPropertiesSet((CamelContext)camelContext);
        for (MainListener listener : listeners) {
            listener.afterConfigure((BaseMainSupport)controller.getMain());
        }
        return camelContext;
    }

    protected static Map<String, String> doExtractVariablesFromSpringBoot(ConfigurableEnvironment env) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        env.getPropertySources().forEach(ps -> {
            if (ps instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)ps;
                for (String n : eps.getPropertyNames()) {
                    if (!n.startsWith("camel.variable.")) continue;
                    String v = env.getRequiredProperty(n);
                    n = n.substring(15);
                    answer.put(n, v);
                }
            }
        });
        return answer;
    }

    static void configureDebugger(ApplicationContext applicationContext, CamelContext camelContext) {
        try {
            DebuggerConfigurationProperties debug = (DebuggerConfigurationProperties)applicationContext.getBean(DebuggerConfigurationProperties.class);
            DefaultConfigurationConfigurer.configureBacklogDebugger((CamelContext)camelContext, (DebuggerConfigurationProperties)debug);
        }
        catch (BeansException debug) {
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    static void configureCliConnector(ApplicationContext applicationContext, CamelContext camelContext) {
        try {
            CliConnectorFactory ccf = (CliConnectorFactory)applicationContext.getBean(CliConnectorFactory.class);
            CliConnector connector = ccf.createConnector();
            camelContext.addService((Object)connector, true);
            ServiceHelper.startService((Service)connector);
        }
        catch (BeansException ccf) {
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    static void configureStartupRecorder(CamelContext camelContext, CamelConfigurationProperties config) {
        StartupStepRecorder fr;
        if ("false".equals(config.getMain().getStartupRecorder())) {
            camelContext.getCamelContextExtension().getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(config.getMain().getStartupRecorder())) {
            camelContext.getCamelContextExtension().setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
        } else if (("java-flight-recorder".equals(config.getMain().getStartupRecorder()) || config.getMain().getStartupRecorder() == null) && (fr = (StartupStepRecorder)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(config.getMain().isStartupRecorderRecording());
            fr.setStartupRecorderDuration(config.getMain().getStartupRecorderDuration());
            fr.setRecordingProfile(config.getMain().getStartupRecorderProfile());
            fr.setMaxDepth(config.getMain().getStartupRecorderMaxDepth());
            camelContext.getCamelContextExtension().setStartupStepRecorder(fr);
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    @ConditionalOnMissingClass(value={"org.apache.camel.spring.boot.endpointdsl.EndpointDslRouteCollector"})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        return new CamelSpringBootRoutesCollector(applicationContext, config.getMain().isIncludeNonSingletons());
    }

    @Bean
    @ConditionalOnMissingBean(value={CamelSpringBootApplicationListener.class})
    CamelSpringBootApplicationListener routesCollectorListener(ApplicationContext applicationContext, CamelConfigurationProperties config, RoutesCollector routesCollector) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new CamelSpringBootApplicationListener(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config, routesCollector);
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={FluentProducerTemplate.class})
    @Lazy
    FluentProducerTemplate fluentProducerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        FluentProducerTemplate fluentProducerTemplate = camelContext.createFluentProducerTemplate(config.getMain().getProducerTemplateCacheSize());
        camelContext.addService((Object)fluentProducerTemplate);
        return fluentProducerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    @Lazy
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate(config.getMain().getProducerTemplateCacheSize());
        camelContext.addService((Object)producerTemplate);
        return producerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    @Lazy
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ConsumerTemplate consumerTemplate = camelContext.createConsumerTemplate(config.getMain().getConsumerTemplateCacheSize());
        camelContext.addService((Object)consumerTemplate);
        return consumerTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={PropertiesParser.class})
    PropertiesParser propertiesParser(Environment env) {
        return new SpringPropertiesParser(env);
    }

    @Bean(destroyMethod="")
    org.apache.camel.component.properties.PropertiesComponent properties(ApplicationContext applicationContext, PropertiesParser parser, PropertiesComponentConfiguration configuration) {
        Properties prop;
        org.apache.camel.component.properties.PropertiesComponent pc = new org.apache.camel.component.properties.PropertiesComponent();
        if (configuration.getAutoDiscoverPropertiesSources() != null) {
            pc.setAutoDiscoverPropertiesSources(configuration.getAutoDiscoverPropertiesSources().booleanValue());
        }
        if (configuration.getDefaultFallbackEnabled() != null) {
            pc.setDefaultFallbackEnabled(configuration.getDefaultFallbackEnabled().booleanValue());
        }
        if (configuration.getEncoding() != null) {
            pc.setEncoding(configuration.getEncoding());
        }
        if (configuration.getEnvironmentVariableMode() != null) {
            pc.setEnvironmentVariableMode(configuration.getEnvironmentVariableMode().intValue());
        }
        if (configuration.getSystemPropertiesMode() != null) {
            pc.setSystemPropertiesMode(configuration.getSystemPropertiesMode().intValue());
        }
        if (configuration.getIgnoreMissingLocation() != null) {
            pc.setIgnoreMissingLocation(configuration.getIgnoreMissingLocation().booleanValue());
        }
        if (configuration.getNestedPlaceholder() != null) {
            pc.setNestedPlaceholder(configuration.getNestedPlaceholder().booleanValue());
        }
        if (configuration.getLocation() != null) {
            pc.setLocation(configuration.getLocation());
        }
        if (configuration.getInitialProperties() != null) {
            prop = (Properties)applicationContext.getBean(configuration.getInitialProperties(), Properties.class);
            pc.setInitialProperties(prop);
        }
        if (configuration.getOverrideProperties() != null) {
            prop = (Properties)applicationContext.getBean(configuration.getOverrideProperties(), Properties.class);
            pc.setOverrideProperties(prop);
        }
        if (configuration.getPropertiesParser() != null) {
            PropertiesParser pp = (PropertiesParser)applicationContext.getBean(configuration.getPropertiesParser(), PropertiesParser.class);
            pc.setPropertiesParser(pp);
        } else {
            pc.setPropertiesParser(parser);
        }
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        return new CamelSpringBootBeanPostProcessor(applicationContext);
    }

    @Bean
    StartupConditionStrategy startupConditionStrategy(CamelStartupConditionConfigurationProperties config) {
        String file;
        DefaultStartupConditionStrategy scs = new DefaultStartupConditionStrategy();
        scs.setEnabled(config.isEnabled());
        scs.setInterval(config.getInterval());
        scs.setTimeout(config.getTimeout());
        scs.setOnTimeout(config.getOnTimeout());
        String envExist = config.getEnvironmentVariableExists();
        if (envExist != null) {
            scs.addStartupCondition((StartupCondition)new EnvStartupCondition(envExist));
        }
        if ((file = config.getFileExists()) != null) {
            scs.addStartupCondition((StartupCondition)new FileStartupCondition(file));
        }
        scs.addStartupConditions(config.getCustomClassNames());
        return scs;
    }
}

