/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class FilePropertySource
extends PropertySource {
    private static final Logger LOG = LoggerFactory.getLogger(FilePropertySource.class);
    private final Properties properties;

    public FilePropertySource(String name, ApplicationContext applicationContext, String directory) {
        super(name);
        StringHelper.notEmpty((String)directory, (String)"directory");
        Properties loaded = new Properties();
        try {
            Resource[] files;
            for (Resource file : files = applicationContext.getResources(directory)) {
                if (!file.exists()) continue;
                try (FileInputStream fis = new FileInputStream(file.getFile());){
                    LOG.debug("Loading properties from file: {}", (Object)file);
                    Properties extra = new Properties();
                    extra.load(fis);
                    if (extra.isEmpty()) continue;
                    loaded.putAll((Map<?, ?>)extra);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (loaded.isEmpty()) {
            this.properties = null;
            LOG.warn("No properties found while loading from: {}", (Object)directory);
        } else {
            this.properties = loaded;
            LOG.info("Loaded {} properties from: {}", (Object)this.properties.size(), (Object)directory);
        }
    }

    public Object getProperty(String name) {
        String answer = this.properties != null ? this.properties.getProperty(name) : null;
        LOG.trace("getProperty {} -> {}", (Object)name, (Object)answer);
        return answer;
    }
}

