/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.springboot")
public class CamelConfigurationProperties
extends DefaultConfigurationProperties<CamelConfigurationProperties> {
    private boolean mainRunController;
    private boolean includeNonSingletons;
    private boolean warnOnEarlyShutdown = true;
    private String name;
    private StartupSummaryLevel startupSummaryLevel = StartupSummaryLevel.Default;
    private int shutdownTimeout = 300;
    private boolean shutdownSuppressLoggingOnTimeout;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean shutdownLogInflightExchangesOnTimeout = true;
    private boolean jmxEnabled = true;
    private int producerTemplateCacheSize = 1000;
    private int consumerTemplateCacheSize = 1000;
    private boolean loadTypeConverters = true;
    private String fileConfigurations;
    private String routeFilterIncludePattern;
    private String routeFilterExcludePattern;
    private int durationMaxSeconds;
    private int durationMaxIdleSeconds;
    private int durationMaxMessages;
    private int logDebugMaxChars;
    private boolean streamCachingEnabled;
    private String streamCachingSpoolDirectory;
    private String streamCachingSpoolCipher;
    private long streamCachingSpoolThreshold;
    private int streamCachingSpoolUsedHeapMemoryThreshold;
    private String streamCachingSpoolUsedHeapMemoryLimit;
    private boolean streamCachingAnySpoolRules;
    private int streamCachingBufferSize;
    private boolean streamCachingRemoveSpoolDirectoryWhenStopping = true;
    private boolean streamCachingStatisticsEnabled;
    private boolean backlogTracing;
    private boolean tracing;
    private String tracingPattern;
    private boolean messageHistory = true;
    private boolean logMask;
    private boolean logExhaustedMessageBody;
    private boolean autoStartup = true;
    private boolean allowUseOriginalMessage;
    private boolean caseInsensitiveHeaders = true;
    private boolean autowiredEnabled = true;
    private boolean inflightRepositoryBrowseEnabled;
    private boolean endpointRuntimeStatisticsEnabled;
    public boolean endpointBridgeErrorHandler;
    public boolean endpointBasicPropertyBinding;
    private boolean endpointLazyStartProducer;
    private boolean useDataType;
    private boolean useBreadcrumb;
    private boolean beanPostProcessorEnabled = true;
    private boolean allowAddingNewRoutes = true;
    private ManagementStatisticsLevel jmxManagementStatisticsLevel = ManagementStatisticsLevel.Default;
    private String jmxManagementNamePattern = "#name#";
    private boolean useMdcLogging;
    private String mdcLoggingKeysPattern;
    private String threadNamePattern;
    private boolean beanIntrospectionExtendedStatistics;
    private LoggingLevel beanIntrospectionLoggingLevel;
    private boolean routesCollectorEnabled = true;
    private String routesIncludePattern = "classpath:camel/*.xml,classpath:camel-template/*.xml,classpath:camel-rest/*.xml";
    private String routesExcludePattern;
    private String javaRoutesIncludePattern;
    private String javaRoutesExcludePattern;
    private String xmlRoutes = "classpath:camel/*.xml";
    private String xmlRouteTemplates = "classpath:camel-template/*.xml";
    private String xmlRests = "classpath:camel-rest/*.xml";
    @Deprecated
    private LoggingLevel routeControllerLoggingLevel;
    boolean routeControllerSuperviseEnabled;
    int routeControllerThreadPoolSize = 1;
    long routeControllerInitialDelay;
    long routeControllerBackOffDelay = 2000L;
    long routeControllerBackOffMaxDelay;
    long routeControllerBackOffMaxElapsedTime;
    long routeControllerBackOffMaxAttempts;
    double routeControllerBackOffMultiplier = 1.0;
    String routeControllerIncludeRoutes;
    String routeControllerExcludeRoutes;
    private boolean routeControllerUnhealthyOnExhausted;
    private boolean lightweight;
    private String startupRecorder = "false";
    private int startupRecorderMaxDepth = -1;
    private boolean startupRecorderRecording;
    private String startupRecorderProfile = "default";
    private long startupRecorderDuration;
    private String startupRecorderDir;

    public boolean isMainRunController() {
        return this.mainRunController;
    }

    public void setMainRunController(boolean mainRunController) {
        this.mainRunController = mainRunController;
    }

    public boolean isIncludeNonSingletons() {
        return this.includeNonSingletons;
    }

    public void setIncludeNonSingletons(boolean includeNonSingletons) {
        this.includeNonSingletons = includeNonSingletons;
    }

    public boolean isWarnOnEarlyShutdown() {
        return this.warnOnEarlyShutdown;
    }

    public void setWarnOnEarlyShutdown(boolean warnOnEarlyShutdown) {
        this.warnOnEarlyShutdown = warnOnEarlyShutdown;
    }
}

