/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.health;

import java.util.Map;
import org.apache.camel.util.ObjectHelper;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.health.check.routes")
public class HealthCheckRoutesConfiguration {
    private boolean enabled;
    private ThresholdsConfiguration thresholds = new ThresholdsConfiguration();
    private Map<String, RouteThresholdsConfiguration> threshold;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ThresholdsConfiguration getThresholds() {
        return this.thresholds;
    }

    public Map<String, RouteThresholdsConfiguration> getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Map<String, RouteThresholdsConfiguration> threshold) {
        this.threshold = threshold;
    }

    public ThresholdsConfiguration getThreshold(String id) {
        ThresholdsConfiguration cfg;
        if (this.threshold == null) {
            cfg = this.thresholds.copy();
        } else {
            RouteThresholdsConfiguration routeCfg = this.threshold.get(id);
            if (routeCfg == null) {
                cfg = this.thresholds.copy();
            } else {
                cfg = routeCfg;
                if (routeCfg.isInherit()) {
                    routeCfg.exchangesFailed = (Long)ObjectHelper.supplyIfEmpty((Object)cfg.exchangesFailed, this.thresholds::getExchangesFailed);
                    routeCfg.exchangesInflight = (Long)ObjectHelper.supplyIfEmpty((Object)cfg.exchangesInflight, this.thresholds::getExchangesInflight);
                    routeCfg.redeliveries = (Long)ObjectHelper.supplyIfEmpty((Object)cfg.redeliveries, this.thresholds::getRedeliveries);
                    routeCfg.externalRedeliveries = (Long)ObjectHelper.supplyIfEmpty((Object)cfg.externalRedeliveries, this.thresholds::getExternalRedeliveries);
                    routeCfg.externalRedeliveries = (Long)ObjectHelper.supplyIfEmpty((Object)cfg.externalRedeliveries, this.thresholds::getExternalRedeliveries);
                    routeCfg.lastProcessingTime = (ThresholdsWithFailuresConfiguration)ObjectHelper.supplyIfEmpty((Object)cfg.lastProcessingTime, this.thresholds::getLastProcessingTime);
                    routeCfg.minProcessingTime = (ThresholdsWithFailuresConfiguration)ObjectHelper.supplyIfEmpty((Object)cfg.minProcessingTime, this.thresholds::getMinProcessingTime);
                    routeCfg.meanProcessingTime = (ThresholdsWithFailuresConfiguration)ObjectHelper.supplyIfEmpty((Object)cfg.meanProcessingTime, this.thresholds::getMeanProcessingTime);
                    routeCfg.maxProcessingTime = (ThresholdsWithFailuresConfiguration)ObjectHelper.supplyIfEmpty((Object)cfg.maxProcessingTime, this.thresholds::getMaxProcessingTime);
                }
            }
        }
        return cfg;
    }

    public static class ThresholdsWithFailuresConfiguration {
        private String threshold;
        private Integer failures;

        public String getThreshold() {
            return this.threshold;
        }

        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        public Integer getFailures() {
            return this.failures;
        }

        public void setFailures(Integer failures) {
            this.failures = failures;
        }
    }

    public static class RouteThresholdsConfiguration
    extends ThresholdsConfiguration {
        private boolean inherit = true;

        public boolean isInherit() {
            return this.inherit;
        }

        public void setInherit(boolean inherit) {
            this.inherit = inherit;
        }
    }

    public static class ThresholdsConfiguration
    implements Cloneable {
        protected Long exchangesFailed;
        protected Long exchangesInflight;
        protected Long redeliveries;
        protected Long externalRedeliveries;
        protected ThresholdsWithFailuresConfiguration lastProcessingTime;
        protected ThresholdsWithFailuresConfiguration minProcessingTime;
        protected ThresholdsWithFailuresConfiguration meanProcessingTime;
        protected ThresholdsWithFailuresConfiguration maxProcessingTime;

        public Long getExchangesFailed() {
            return this.exchangesFailed;
        }

        public void setExchangesFailed(Long exchangesFailed) {
            this.exchangesFailed = exchangesFailed;
        }

        public Long getExchangesInflight() {
            return this.exchangesInflight;
        }

        public void setExchangesInflight(Long exchangesInflight) {
            this.exchangesInflight = exchangesInflight;
        }

        public Long getRedeliveries() {
            return this.redeliveries;
        }

        public void setRedeliveries(Long redeliveries) {
            this.redeliveries = redeliveries;
        }

        public Long getExternalRedeliveries() {
            return this.externalRedeliveries;
        }

        public void setExternalRedeliveries(Long externalRedeliveries) {
            this.externalRedeliveries = externalRedeliveries;
        }

        public ThresholdsWithFailuresConfiguration getLastProcessingTime() {
            return this.lastProcessingTime;
        }

        public void setLastProcessingTime(ThresholdsWithFailuresConfiguration lastProcessingTime) {
            this.lastProcessingTime = lastProcessingTime;
        }

        public ThresholdsWithFailuresConfiguration getMinProcessingTime() {
            return this.minProcessingTime;
        }

        public void setMinProcessingTime(ThresholdsWithFailuresConfiguration minProcessingTime) {
            this.minProcessingTime = minProcessingTime;
        }

        public ThresholdsWithFailuresConfiguration getMeanProcessingTime() {
            return this.meanProcessingTime;
        }

        public void setMeanProcessingTime(ThresholdsWithFailuresConfiguration meanProcessingTime) {
            this.meanProcessingTime = meanProcessingTime;
        }

        public ThresholdsWithFailuresConfiguration getMaxProcessingTime() {
            return this.maxProcessingTime;
        }

        public void setMaxProcessingTime(ThresholdsWithFailuresConfiguration maxProcessingTime) {
            this.maxProcessingTime = maxProcessingTime;
        }

        public ThresholdsConfiguration copy() {
            try {
                return (ThresholdsConfiguration)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

