/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.properties.PropertiesComponentConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={PropertiesComponentConfiguration.class})
public class PropertiesComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;

    @Lazy
    @Bean(name={"properties-component"})
    @ConditionalOnMissingBean(value={PropertiesComponent.class})
    public PropertiesComponent configurePropertiesComponent(PropertiesComponentConfiguration configuration) throws Exception {
        Properties prop;
        PropertiesComponent component = new PropertiesComponent();
        component.setCamelContext(this.camelContext);
        if (configuration.getAutoDiscoverPropertiesSources() != null) {
            component.setAutoDiscoverPropertiesSources(configuration.getAutoDiscoverPropertiesSources().booleanValue());
        }
        if (configuration.getDefaultFallbackEnabled() != null) {
            component.setDefaultFallbackEnabled(configuration.getDefaultFallbackEnabled().booleanValue());
        }
        if (configuration.getEncoding() != null) {
            component.setEncoding(configuration.getEncoding());
        }
        if (configuration.getEnvironmentVariableMode() != null) {
            component.setEnvironmentVariableMode(configuration.getEnvironmentVariableMode().intValue());
        }
        if (configuration.getSystemPropertiesMode() != null) {
            component.setSystemPropertiesMode(configuration.getSystemPropertiesMode().intValue());
        }
        if (configuration.getIgnoreMissingLocation() != null) {
            component.setIgnoreMissingLocation(configuration.getIgnoreMissingLocation().booleanValue());
        }
        if (configuration.getLocation() != null) {
            component.setLocation(configuration.getLocation());
        }
        if (configuration.getInitialProperties() != null) {
            prop = (Properties)this.camelContext.getRegistry().lookupByNameAndType(configuration.getInitialProperties(), Properties.class);
            component.setInitialProperties(prop);
        }
        if (configuration.getOverrideProperties() != null) {
            prop = (Properties)this.camelContext.getRegistry().lookupByNameAndType(configuration.getOverrideProperties(), Properties.class);
            component.setOverrideProperties(prop);
        }
        if (configuration.getPropertiesParser() != null) {
            PropertiesParser parser = (PropertiesParser)this.camelContext.getRegistry().lookupByNameAndType(configuration.getPropertiesParser(), PropertiesParser.class);
            component.setPropertiesParser(parser);
        }
        return component;
    }
}

