/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.spi.Language;
import org.apache.camel.spring.boot.cloud.CamelCloudAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelCloudAutoConfiguration.class, CamelContext.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
@Conditional(value={ServiceCallCondition.class})
public class CamelCloudServiceCallConfigurationAutoConfiguration {
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private CamelCloudConfigurationProperties configurationProperties;

    @Lazy
    @Bean(name={"service-call-configuration"})
    @ConditionalOnMissingBean(name={"service-call-configuration"})
    public ServiceCallConfigurationDefinition serviceCallConfiguration() throws Exception {
        ServiceCallConfigurationDefinition definition = new ServiceCallConfigurationDefinition();
        CamelCloudConfigurationProperties.ServiceCall serviceCall = this.configurationProperties.getServiceCall();
        ObjectHelper.ifNotEmpty((Object)serviceCall.getComponent(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setComponent(arg_0));
        ObjectHelper.ifNotEmpty((Object)serviceCall.getUri(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setUri(arg_0));
        ObjectHelper.ifNotEmpty((Object)serviceCall.getServiceDiscovery(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setServiceDiscoveryRef(arg_0));
        ObjectHelper.ifNotEmpty((Object)serviceCall.getServiceFilter(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setServiceFilterRef(arg_0));
        ObjectHelper.ifNotEmpty((Object)serviceCall.getServiceChooser(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setServiceChooserRef(arg_0));
        ObjectHelper.ifNotEmpty((Object)serviceCall.getLoadBalancer(), arg_0 -> ((ServiceCallConfigurationDefinition)definition).setLoadBalancerRef(arg_0));
        if (serviceCall.getLoadBalancer() == null && serviceCall.isDefaultLoadBalancer()) {
            definition.defaultLoadBalancer();
        }
        String expression = serviceCall.getExpression();
        String expressionLanguage = serviceCall.getExpressionLanguage();
        if (ObjectHelper.isNotEmpty((Object)expression) && ObjectHelper.isNotEmpty((Object)expressionLanguage)) {
            Language language = this.camelContext.resolveLanguage(expressionLanguage);
            if (language == null) {
                throw new IllegalArgumentException("Unable to resolve language: " + expressionLanguage);
            }
            definition.setExpression(language.createExpression(expression));
        }
        return definition;
    }

    public static class ServiceCallCondition
    extends GroupCondition {
        public ServiceCallCondition() {
            super("camel.cloud", "camel.cloud.service-call");
        }
    }
}

