/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.health.HealthCheckConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.health")
public class CamelHealthCheckConfigurationProperties {
    private Boolean enabled;
    private Boolean contextEnabled;
    private Boolean routesEnabled;
    private Boolean registryEnabled;
    private Map<String, HealthCheckConfigurationProperties> config = new HashMap<String, HealthCheckConfigurationProperties>();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getContextEnabled() {
        return this.contextEnabled;
    }

    public void setContextEnabled(Boolean contextEnabled) {
        this.contextEnabled = contextEnabled;
    }

    public Boolean getRoutesEnabled() {
        return this.routesEnabled;
    }

    public void setRoutesEnabled(Boolean routesEnabled) {
        this.routesEnabled = routesEnabled;
    }

    public Boolean getRegistryEnabled() {
        return this.registryEnabled;
    }

    public void setRegistryEnabled(Boolean registryEnabled) {
        this.registryEnabled = registryEnabled;
    }

    public Map<String, HealthCheckConfigurationProperties> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, HealthCheckConfigurationProperties> config) {
        this.config = config;
    }

    @ConfigurationProperties(prefix="camel.health.config")
    public static class HealthCheckConfigurationProperties {
        private String parent;
        private Boolean enabled;
        private Long interval;
        private Integer failureThreshold;

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Long getInterval() {
            return this.interval;
        }

        public void setInterval(Long interval) {
            this.interval = interval;
        }

        public Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        public void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public HealthCheckConfiguration toHealthCheckConfiguration() {
            HealthCheckConfiguration answer = new HealthCheckConfiguration();
            answer.setParent(this.parent);
            if (this.enabled != null) {
                answer.setEnabled(this.enabled.booleanValue());
            }
            if (this.interval != null) {
                answer.setInterval(this.interval.longValue());
            }
            if (this.failureThreshold != null) {
                answer.setFailureThreshold(this.failureThreshold.intValue());
            }
            return answer;
        }
    }
}

