/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthIndicator;
import org.apache.camel.spring.boot.health.HealthCheckVerboseConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={HealthCheckVerboseConfiguration.class})
public class CamelHealthAutoConfiguration {
    private HealthCheckVerboseConfiguration properties;

    public CamelHealthAutoConfiguration(HealthCheckVerboseConfiguration configuration) {
        this.properties = configuration;
    }

    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CamelHealthIndicator.class})
    protected class CamelHealthIndicatorInitializer {
        protected CamelHealthIndicatorInitializer() {
        }

        @Bean
        public HealthIndicator camelHealthIndicator(CamelContext camelContext) {
            return new CamelHealthIndicator(camelContext, CamelHealthAutoConfiguration.this.properties);
        }
    }
}

