/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class SpringBootRoutesCollector
extends DefaultRoutesCollector {
    private final ApplicationContext applicationContext;

    public SpringBootRoutesCollector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        AntPathMatcher matcher = new AntPathMatcher();
        for (RoutesBuilder routesBuilder : this.applicationContext.getBeansOfType(RoutesBuilder.class, true, true).values()) {
            String[] parts;
            boolean match;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean bl = match = !"false".equals(includePattern);
            if (match && ObjectHelper.isNotEmpty((Object)excludePattern)) {
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            excludePattern = System.getProperty("CamelTestSpringExcludeRoutes");
            if (match && ObjectHelper.isNotEmpty((Object)excludePattern)) {
                excludePattern = excludePattern.replace('.', '/');
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((Object)includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }

    public List<RoutesDefinition> collectXmlRoutesFromDirectory(CamelContext camelContext, String directory) {
        String[] parts;
        ArrayList<RoutesDefinition> answer = new ArrayList<RoutesDefinition>();
        for (String part : parts = directory.split(",")) {
            this.log.info("Loading additional Camel XML routes from: {}", (Object)part);
            try {
                Resource[] xmlRoutes;
                for (Resource xmlRoute : xmlRoutes = this.applicationContext.getResources(part)) {
                    this.log.debug("Found XML route: {}", (Object)xmlRoute);
                    ExtendedCamelContext extendedCamelContext = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
                    XMLRoutesDefinitionLoader xmlLoader = extendedCamelContext.getXMLRoutesDefinitionLoader();
                    RoutesDefinition routes = (RoutesDefinition)xmlLoader.loadRoutesDefinition(camelContext, xmlRoute.getInputStream());
                    answer.add(routes);
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No XML routes found in {}. Skipping XML routes detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return answer;
    }

    public List<RestsDefinition> collectXmlRestsFromDirectory(CamelContext camelContext, String directory) {
        String[] parts;
        ArrayList<RestsDefinition> answer = new ArrayList<RestsDefinition>();
        for (String part : parts = directory.split(",")) {
            this.log.info("Loading additional Camel XML rests from: {}", (Object)part);
            try {
                Resource[] xmlRests;
                for (Resource xmlRest : xmlRests = this.applicationContext.getResources(part)) {
                    ExtendedCamelContext extendedCamelContext = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
                    XMLRoutesDefinitionLoader xmlLoader = extendedCamelContext.getXMLRoutesDefinitionLoader();
                    RestsDefinition rests = (RestsDefinition)xmlLoader.loadRestsDefinition(camelContext, xmlRest.getInputStream());
                    answer.add(rests);
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return answer;
    }
}

