/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class JpaComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, EntityManagerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PlatformTransactionManager.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.persistence.EntityManagerFactory": {
                return this.applicationContext.getBean(ref, EntityManagerFactory.class);
            }
            case "org.springframework.transaction.PlatformTransactionManager": {
                return this.applicationContext.getBean(ref, PlatformTransactionManager.class);
            }
        }
        return null;
    }
}

