/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.DefaultKeySelector;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.w3c.dom.Node;

public class DefaultKeyAccessor
extends DefaultKeySelector
implements KeyAccessor {
    private String provider;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public KeySelector getKeySelector(Message message) throws Exception {
        return this;
    }

    @Override
    public KeyInfo getKeyInfo(Message message, Node messageBody, KeyInfoFactory factory) throws Exception {
        return this.createKeyInfo(factory);
    }

    private KeyInfo createKeyInfo(KeyInfoFactory kif) throws Exception {
        X509Certificate[] chain = this.getCertificateChain();
        if (chain == null) {
            return null;
        }
        X509Data x509D = kif.newX509Data(Arrays.asList(chain));
        return kif.newKeyInfo(Collections.singletonList(x509D), "_" + UUID.randomUUID().toString());
    }

    private X509Certificate[] getCertificateChain() throws Exception {
        KeyStore keystore = this.getKeyStore();
        if (keystore == null) {
            return null;
        }
        String alias = this.getAlias();
        if (alias == null) {
            return null;
        }
        Certificate[] certs = keystore.getCertificateChain(alias);
        if (certs == null) {
            return null;
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(certs.length);
        for (Certificate cert : certs) {
            if (!(cert instanceof X509Certificate)) continue;
            certList.add((X509Certificate)cert);
        }
        return certList.toArray(new X509Certificate[certList.size()]);
    }
}

