/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.spring.CamelAnnotationsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class CamelSpringBootExecutionListener
extends AbstractTestExecutionListener {
    protected static ThreadLocal<ConfigurableApplicationContext> threadApplicationContext = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootExecutionListener.class);

    public void prepareTestInstance(TestContext testContext) throws Exception {
        LOG.info("@RunWith(CamelSpringBootRunner.class) preparing: {}", (Object)testContext.getTestClass());
        Class testClass = testContext.getTestClass();
        CamelAnnotationsHandler.handleExcludeRoutesForSpringBoot(testClass);
        SpringCamelContext.setNoStart((boolean)true);
        System.setProperty("skipStartingCamelContext", "true");
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        CamelAnnotationsHandler.handleProvidesBreakpoint(context, testClass);
        CamelAnnotationsHandler.handleShutdownTimeout(context, testClass);
        CamelAnnotationsHandler.handleMockEndpoints(context, testClass);
        CamelAnnotationsHandler.handleMockEndpointsAndSkip(context, testClass);
        CamelAnnotationsHandler.handleUseOverridePropertiesWithPropertiesComponent(context, testClass);
        System.clearProperty("skipStartingCamelContext");
        SpringCamelContext.setNoStart((boolean)false);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        LOG.info("@RunWith(CamelSpringBootRunner.class) before: {}.{}", (Object)testContext.getTestClass(), (Object)testContext.getTestMethod().getName());
        Class testClass = testContext.getTestClass();
        String testName = testContext.getTestMethod().getName();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        threadApplicationContext.set(context);
        System.clearProperty("skipStartingCamelContext");
        CamelAnnotationsHandler.handleRouteCoverage(context, testClass, s -> testName);
        LOG.info("Initialized CamelSpringBootRunner now ready to start CamelContext");
        CamelAnnotationsHandler.handleCamelContextStartup(context, testClass);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        LOG.info("@RunWith(CamelSpringBootRunner.class) after: {}.{}", (Object)testContext.getTestClass(), (Object)testContext.getTestMethod().getName());
        Class testClass = testContext.getTestClass();
        String testName = testContext.getTestMethod().getName();
        ConfigurableApplicationContext context = threadApplicationContext.get();
        if (context != null && context.isRunning()) {
            CamelAnnotationsHandler.handleRouteCoverageDump(context, testClass, s -> testName);
        }
    }
}

