/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.lang.reflect.Method;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.spring.CamelAnnotationsHandler;
import org.apache.camel.test.spring.CamelSpringTestHelper;
import org.apache.camel.test.spring.DisableJmx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DelegatingSmartContextLoader;

@Deprecated
public class CamelSpringDelegatingTestContextLoader
extends DelegatingSmartContextLoader {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading ApplicationContext for merged context configuration [{}].", (Object)mergedConfig);
        }
        CamelAnnotationsHandler.handleDisableJmx(null, testClass);
        try {
            SpringCamelContext.setNoStart((boolean)true);
            System.setProperty("skipStartingCamelContext", "true");
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)super.loadContext(mergedConfig);
            SpringCamelContext.setNoStart((boolean)false);
            System.clearProperty("skipStartingCamelContext");
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            this.cleanup(testClass);
        }
    }

    public ApplicationContext loadContext(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)((BeanDefinitionRegistry)context));
        CamelAnnotationsHandler.handleRouteCoverage(context, testClass, s -> this.getTestMethod().getName());
        CamelAnnotationsHandler.handleProvidesBreakpoint(context, testClass);
        CamelAnnotationsHandler.handleShutdownTimeout(context, testClass);
        CamelAnnotationsHandler.handleMockEndpoints(context, testClass);
        CamelAnnotationsHandler.handleMockEndpointsAndSkip(context, testClass);
        CamelAnnotationsHandler.handleUseOverridePropertiesWithPropertiesComponent(context, testClass);
        CamelAnnotationsHandler.handleCamelContextStartup(context, testClass);
        return context;
    }

    protected void cleanup(Class<?> testClass) {
        SpringCamelContext.setNoStart((boolean)false);
        if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (CamelSpringTestHelper.getOriginalJmxDisabled() == null) {
                System.clearProperty("org.apache.camel.jmx.disabled");
            } else {
                System.setProperty("org.apache.camel.jmx.disabled", CamelSpringTestHelper.getOriginalJmxDisabled());
            }
        }
    }

    protected Class<?> getTestClass() {
        return CamelSpringTestHelper.getTestClass();
    }

    protected Method getTestMethod() {
        return CamelSpringTestHelper.getTestMethod();
    }
}

