/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tensorflow.serving;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import tensorflow.serving.Classification;
import tensorflow.serving.GetModelMetadata;
import tensorflow.serving.GetModelStatus;
import tensorflow.serving.InputOuterClass;
import tensorflow.serving.Predict;
import tensorflow.serving.RegressionOuterClass;

@DeferredContextBinding
public final class TensorFlowServingConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        TensorFlowServingConverterLoader.addTypeConverter(registry, Classification.ClassificationRequest.class, Classification.ClassificationRequest.Builder.class, false, (type, exchange, value) -> {
            Classification.ClassificationRequest answer = TensorFlowServingConverter.toClassificationRequest((Classification.ClassificationRequest.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, Classification.ClassificationRequest.class, InputOuterClass.Input.class, false, (type, exchange, value) -> {
            Classification.ClassificationRequest answer = TensorFlowServingConverter.toClassificationRequest((InputOuterClass.Input)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, Classification.ClassificationRequest.class, InputOuterClass.Input.Builder.class, false, (type, exchange, value) -> {
            Classification.ClassificationRequest answer = TensorFlowServingConverter.toClassificationRequest((InputOuterClass.Input.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, GetModelMetadata.GetModelMetadataRequest.class, GetModelMetadata.GetModelMetadataRequest.Builder.class, false, (type, exchange, value) -> {
            GetModelMetadata.GetModelMetadataRequest answer = TensorFlowServingConverter.toGetModelMetadataRequest((GetModelMetadata.GetModelMetadataRequest.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, GetModelStatus.GetModelStatusRequest.class, GetModelStatus.GetModelStatusRequest.Builder.class, false, (type, exchange, value) -> {
            GetModelStatus.GetModelStatusRequest answer = TensorFlowServingConverter.toGetModelStatusRequest((GetModelStatus.GetModelStatusRequest.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, Predict.PredictRequest.class, Predict.PredictRequest.Builder.class, false, (type, exchange, value) -> {
            Predict.PredictRequest answer = TensorFlowServingConverter.toPredictRequest((Predict.PredictRequest.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, RegressionOuterClass.RegressionRequest.class, InputOuterClass.Input.class, false, (type, exchange, value) -> {
            RegressionOuterClass.RegressionRequest answer = TensorFlowServingConverter.toRegressionRequest((InputOuterClass.Input)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, RegressionOuterClass.RegressionRequest.class, InputOuterClass.Input.Builder.class, false, (type, exchange, value) -> {
            RegressionOuterClass.RegressionRequest answer = TensorFlowServingConverter.toRegressionRequest((InputOuterClass.Input.Builder)value);
            return answer;
        });
        TensorFlowServingConverterLoader.addTypeConverter(registry, RegressionOuterClass.RegressionRequest.class, RegressionOuterClass.RegressionRequest.Builder.class, false, (type, exchange, value) -> {
            RegressionOuterClass.RegressionRequest answer = TensorFlowServingConverter.toRegressionRequest((RegressionOuterClass.RegressionRequest.Builder)value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

