/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseHeaderDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecurityApiKey;
import org.apache.camel.model.rest.RestSecurityBasicAuth;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.model.rest.RestSecurityOAuth2;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.swagger.RestModelConverters;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class RestSwaggerReader {
    public Swagger read(List<RestDefinition> rests, String route, BeanConfig config, String camelContextId, ClassResolver classResolver) {
        Swagger swagger = new Swagger();
        for (RestDefinition rest : rests) {
            if (ObjectHelper.isNotEmpty((Object)route) && !route.equals("/") && !rest.getPath().equals(route)) continue;
            this.parse(swagger, rest, camelContextId, classResolver);
        }
        swagger = config.configure(swagger);
        return swagger;
    }

    private void parse(Swagger swagger, RestDefinition rest, String camelContextId, ClassResolver classResolver) {
        RestSecuritiesDefinition sd;
        ArrayList<VerbDefinition> verbs = new ArrayList<VerbDefinition>(rest.getVerbs());
        Collections.sort(verbs, new VerbOrdering());
        String pathAsTag = rest.getTag() != null ? rest.getTag() : FileUtil.stripLeadingSeparator((String)rest.getPath());
        String summary = rest.getDescriptionText();
        if (ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            Tag tag = new Tag();
            tag.description(summary);
            tag.name(pathAsTag);
            swagger.addTag(tag);
        }
        if ((sd = rest.getSecurityDefinitions()) != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                ApiKeyAuthDefinition auth;
                RestSecurityApiKey rs;
                if (def instanceof RestSecurityBasicAuth) {
                    BasicAuthDefinition auth2 = new BasicAuthDefinition();
                    auth2.setDescription(def.getDescription());
                    swagger.addSecurityDefinition(def.getKey(), (SecuritySchemeDefinition)auth2);
                    continue;
                }
                if (def instanceof RestSecurityApiKey) {
                    rs = (RestSecurityApiKey)def;
                    auth = new ApiKeyAuthDefinition();
                    auth.setDescription(rs.getDescription());
                    auth.setName(rs.getName());
                    if (rs.getInHeader() != null && rs.getInHeader().booleanValue()) {
                        auth.setIn(In.HEADER);
                    } else {
                        auth.setIn(In.QUERY);
                    }
                    swagger.addSecurityDefinition(def.getKey(), (SecuritySchemeDefinition)auth);
                    continue;
                }
                if (!(def instanceof RestSecurityOAuth2)) continue;
                rs = (RestSecurityOAuth2)def;
                auth = new OAuth2Definition();
                auth.setDescription(rs.getDescription());
                String flow = rs.getFlow();
                if (flow == null) {
                    if (rs.getAuthorizationUrl() != null && rs.getTokenUrl() != null) {
                        flow = "accessCode";
                    } else if (rs.getTokenUrl() == null && rs.getAuthorizationUrl() != null) {
                        flow = "implicit";
                    }
                }
                auth.setFlow(flow);
                auth.setAuthorizationUrl(rs.getAuthorizationUrl());
                auth.setTokenUrl(rs.getTokenUrl());
                for (RestPropertyDefinition scope : rs.getScopes()) {
                    auth.addScope(scope.getKey(), scope.getValue());
                }
                swagger.addSecurityDefinition(def.getKey(), (SecuritySchemeDefinition)auth);
            }
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (VerbDefinition verb : verbs) {
            Boolean apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !apiDocs.booleanValue()) continue;
            String type = verb.getType();
            if (ObjectHelper.isNotEmpty((Object)type)) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (ObjectHelper.isNotEmpty((Object)(type = verb.getOutType()))) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (verb.getResponseMsgs() == null) continue;
            for (RestOperationResponseMsgDefinition def : verb.getResponseMsgs()) {
                type = def.getResponseModel();
                if (!ObjectHelper.isNotEmpty((Object)type)) continue;
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
        }
        for (String type : types) {
            Class clazz = classResolver.resolveClass(type);
            this.appendModels(clazz, swagger);
        }
        this.doParseVerbs(swagger, rest, camelContextId, verbs, pathAsTag);
    }

    private void doParseVerbs(Swagger swagger, RestDefinition rest, String camelContextId, List<VerbDefinition> verbs, String pathAsTag) {
        ArrayList<Path> paths = new ArrayList<Path>();
        String basePath = rest.getPath();
        for (VerbDefinition verb : verbs) {
            String produces;
            String consumes;
            Boolean apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !apiDocs.booleanValue()) continue;
            String method = verb.asVerb().toLowerCase(Locale.US);
            String opPath = SwaggerHelper.buildUrl(basePath, verb.getUri());
            Operation op = new Operation();
            if (ObjectHelper.isNotEmpty((Object)pathAsTag)) {
                op.addTag(pathAsTag);
            }
            String routeId = verb.getRouteId();
            String operationId = Optional.ofNullable(rest.getId()).orElse(routeId);
            op.operationId(operationId);
            op.getVendorExtensions().put("x-camelContextId", camelContextId);
            op.getVendorExtensions().put("x-routeId", routeId);
            Path path = swagger.getPath(opPath);
            if (path == null) {
                path = new Path();
                paths.add(path);
            }
            path = path.set(method, op);
            String string = consumes = verb.getConsumes() != null ? verb.getConsumes() : rest.getConsumes();
            if (consumes != null) {
                String[] parts;
                for (String part : parts = consumes.split(",")) {
                    op.addConsumes(part);
                }
            }
            String string2 = produces = verb.getProduces() != null ? verb.getProduces() : rest.getProduces();
            if (produces != null) {
                String[] parts = produces.split(",");
                for (String part : parts) {
                    op.addProduces(part);
                }
            }
            if (verb.getDescriptionText() != null) {
                op.summary(verb.getDescriptionText());
            }
            for (SecurityDefinition sd : verb.getSecurity()) {
                ArrayList<String> scopes = new ArrayList<String>();
                if (sd.getScopes() != null) {
                    Iterator it = ObjectHelper.createIterator((Object)sd.getScopes());
                    while (it.hasNext()) {
                        String scope = it.next().toString();
                        scopes.add(scope);
                    }
                }
                op.addSecurity(sd.getKey(), scopes);
            }
            for (RestOperationParamDefinition param : verb.getParams()) {
                BodyParameter parameter = null;
                if (param.getType().equals((Object)RestParamType.body)) {
                    parameter = new BodyParameter();
                } else if (param.getType().equals((Object)RestParamType.formData)) {
                    parameter = new FormParameter();
                } else if (param.getType().equals((Object)RestParamType.header)) {
                    parameter = new HeaderParameter();
                } else if (param.getType().equals((Object)RestParamType.path)) {
                    parameter = new PathParameter();
                } else if (param.getType().equals((Object)RestParamType.query)) {
                    parameter = new QueryParameter();
                }
                if (parameter == null) continue;
                parameter.setName(param.getName());
                if (ObjectHelper.isNotEmpty((Object)param.getDescription())) {
                    parameter.setDescription(param.getDescription());
                }
                parameter.setRequired(param.getRequired().booleanValue());
                if (parameter instanceof SerializableParameter) {
                    boolean hasAllowableValues;
                    SerializableParameter serializableParameter = (SerializableParameter)parameter;
                    boolean isArray = param.getDataType().equalsIgnoreCase("array");
                    List allowableValues = param.getAllowableValues();
                    boolean bl = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty();
                    if (param.getDataType() != null) {
                        serializableParameter.setType(param.getDataType());
                        if (param.getDataFormat() != null) {
                            serializableParameter.setFormat(param.getDataFormat());
                        }
                        if (isArray && param.getArrayType() != null) {
                            if (param.getArrayType().equalsIgnoreCase("string")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new StringProperty(), String.class);
                            }
                            if (param.getArrayType().equalsIgnoreCase("int") || param.getArrayType().equalsIgnoreCase("integer")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new IntegerProperty(), Integer.class);
                            }
                            if (param.getArrayType().equalsIgnoreCase("long")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new LongProperty(), Long.class);
                            }
                            if (param.getArrayType().equalsIgnoreCase("float")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new FloatProperty(), Float.class);
                            }
                            if (param.getArrayType().equalsIgnoreCase("double")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new DoubleProperty(), Double.class);
                            }
                            if (param.getArrayType().equalsIgnoreCase("boolean")) {
                                RestSwaggerReader.defineItems(serializableParameter, allowableValues, (Property)new BooleanProperty(), Boolean.class);
                            }
                        }
                    }
                    if (param.getCollectionFormat() != null) {
                        serializableParameter.setCollectionFormat(param.getCollectionFormat().name());
                    }
                    if (hasAllowableValues && !isArray) {
                        serializableParameter.setEnum(allowableValues);
                    }
                }
                if (parameter instanceof AbstractSerializableParameter) {
                    AbstractSerializableParameter qp = (AbstractSerializableParameter)parameter;
                    if (ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                        qp.setDefaultValue(param.getDefaultValue());
                    }
                    if (param.getExamples() != null && param.getExamples().size() >= 1) {
                        qp.example(((RestPropertyDefinition)param.getExamples().get(0)).getValue());
                    }
                }
                if (parameter instanceof BodyParameter) {
                    String type;
                    BodyParameter bp = parameter;
                    String string3 = type = param.getDataType() != null ? param.getDataType() : verb.getType();
                    if (type != null) {
                        if (type.endsWith("[]")) {
                            Property prop = this.modelTypeAsProperty(type = type.substring(0, type.length() - 2), swagger);
                            if (prop != null) {
                                ArrayModel arrayModel = new ArrayModel();
                                arrayModel.setItems(prop);
                                bp.setSchema((Model)arrayModel);
                            }
                        } else {
                            String ref = this.modelTypeAsRef(type, swagger);
                            if (ref != null) {
                                bp.setSchema((Model)new RefModel(ref));
                            } else {
                                Property prop = this.modelTypeAsProperty(type, swagger);
                                if (prop != null) {
                                    ModelImpl model = new ModelImpl();
                                    model.setFormat(prop.getFormat());
                                    model.setType(prop.getType());
                                    bp.setSchema((Model)model);
                                }
                            }
                        }
                    }
                    if (param.getExamples() != null) {
                        for (RestPropertyDefinition prop : param.getExamples()) {
                            bp.example(prop.getKey(), prop.getValue());
                        }
                    }
                }
                op.addParameter((Parameter)parameter);
            }
            if (op.getParameters().isEmpty()) {
                op.setParameters(null);
            }
            if (verb.getOutType() != null) {
                Response response = new Response();
                Property prop = this.modelTypeAsProperty(verb.getOutType(), swagger);
                response.setSchema(prop);
                response.setDescription("Output type");
                op.addResponse("200", response);
            }
            this.doParseResponseMessages(swagger, verb, op);
            swagger.path(opPath, path);
        }
    }

    private static void defineItems(SerializableParameter serializableParameter, List<String> allowableValues, Property items, Class<?> type) {
        serializableParameter.setItems(items);
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                ((StringProperty)items).setEnum(allowableValues);
            } else {
                RestSwaggerReader.convertAndSetItemsEnum(items, allowableValues, type);
            }
        }
    }

    private static void convertAndSetItemsEnum(Property items, List<String> allowableValues, Class<?> type) {
        try {
            MethodHandle valueOf = MethodHandles.publicLookup().findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            MethodHandle setEnum = MethodHandles.publicLookup().bind(items, "setEnum", MethodType.methodType(Void.TYPE, List.class));
            List values = allowableValues.stream().map(v -> {
                try {
                    return valueOf.invoke((String)v);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            setEnum.invoke(values);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    private void doParseResponseMessages(Swagger swagger, VerbDefinition verb, Operation op) {
        for (RestOperationResponseMsgDefinition msg : verb.getResponseMsgs()) {
            Response response = null;
            if (op.getResponses() != null) {
                response = (Response)op.getResponses().get(msg.getCode());
            }
            if (response == null) {
                response = new Response();
            }
            if (ObjectHelper.isNotEmpty((Object)msg.getResponseModel())) {
                Property prop = this.modelTypeAsProperty(msg.getResponseModel(), swagger);
                response.setSchema(prop);
            }
            if (ObjectHelper.isNotEmpty((Object)msg.getMessage())) {
                response.setDescription(msg.getMessage());
            }
            if (msg.getHeaders() != null) {
                for (RestOperationResponseHeaderDefinition header : msg.getHeaders()) {
                    ArrayList<Number> values;
                    String name = header.getName();
                    String type = header.getDataType();
                    String format = header.getDataFormat();
                    if ("string".equals(type)) {
                        StringProperty sp = new StringProperty();
                        sp.setName(name);
                        if (format != null) {
                            sp.setFormat(format);
                        }
                        sp.setDescription(header.getDescription());
                        if (header.getAllowableValues() != null) {
                            sp.setEnum(header.getAllowableValues());
                        }
                        if (header.getExample() != null) {
                            sp.example(header.getExample());
                        }
                        response.addHeader(name, (Property)sp);
                        continue;
                    }
                    if ("int".equals(type) || "integer".equals(type)) {
                        IntegerProperty ip = new IntegerProperty();
                        ip.setName(name);
                        if (format != null) {
                            ip.setFormat(format);
                        }
                        ip.setDescription(header.getDescription());
                        if (!header.getAllowableValues().isEmpty()) {
                            values = new ArrayList<Number>();
                            for (String text : header.getAllowableValues()) {
                                values.add(Integer.valueOf(text));
                            }
                            ip.setEnum(values);
                        }
                        if (header.getExample() != null) {
                            ip.example(Integer.valueOf(header.getExample()));
                        }
                        response.addHeader(name, (Property)ip);
                        continue;
                    }
                    if ("long".equals(type)) {
                        LongProperty lp = new LongProperty();
                        lp.setName(name);
                        if (format != null) {
                            lp.setFormat(format);
                        }
                        lp.setDescription(header.getDescription());
                        if (!header.getAllowableValues().isEmpty()) {
                            values = new ArrayList();
                            for (String text : header.getAllowableValues()) {
                                values.add(Long.valueOf(text));
                            }
                            lp.setEnum(values);
                        }
                        if (header.getExample() != null) {
                            lp.example(Long.valueOf(header.getExample()));
                        }
                        response.addHeader(name, (Property)lp);
                        continue;
                    }
                    if ("float".equals(type)) {
                        FloatProperty fp = new FloatProperty();
                        fp.setName(name);
                        if (format != null) {
                            fp.setFormat(format);
                        }
                        fp.setDescription(header.getDescription());
                        if (!header.getAllowableValues().isEmpty()) {
                            values = new ArrayList();
                            for (String text : header.getAllowableValues()) {
                                values.add(Float.valueOf(text));
                            }
                            fp.setEnum(values);
                        }
                        if (header.getExample() != null) {
                            fp.example(Float.valueOf(header.getExample()));
                        }
                        response.addHeader(name, (Property)fp);
                        continue;
                    }
                    if ("double".equals(type)) {
                        DoubleProperty dp = new DoubleProperty();
                        dp.setName(name);
                        if (format != null) {
                            dp.setFormat(format);
                        }
                        dp.setDescription(header.getDescription());
                        if (!header.getAllowableValues().isEmpty()) {
                            values = new ArrayList();
                            for (String text : header.getAllowableValues()) {
                                values.add(Double.valueOf(text));
                            }
                            dp.setEnum(values);
                        }
                        if (header.getExample() != null) {
                            dp.example(Double.valueOf(header.getExample()));
                        }
                        response.addHeader(name, (Property)dp);
                        continue;
                    }
                    if ("boolean".equals(type)) {
                        BooleanProperty bp = new BooleanProperty();
                        bp.setName(name);
                        if (format != null) {
                            bp.setFormat(format);
                        }
                        bp.setDescription(header.getDescription());
                        if (header.getExample() != null) {
                            bp.example(Boolean.valueOf(header.getExample()));
                        }
                        response.addHeader(name, (Property)bp);
                        continue;
                    }
                    if (!"array".equals(type)) continue;
                    ArrayProperty ap = new ArrayProperty();
                    ap.setName(name);
                    if (ObjectHelper.isNotEmpty((Object)header.getDescription())) {
                        ap.setDescription(header.getDescription());
                    }
                    if (header.getArrayType() != null) {
                        if (header.getArrayType().equalsIgnoreCase("string")) {
                            ap.setItems((Property)new StringProperty());
                        }
                        if (header.getArrayType().equalsIgnoreCase("int") || header.getArrayType().equalsIgnoreCase("integer")) {
                            ap.setItems((Property)new IntegerProperty());
                        }
                        if (header.getArrayType().equalsIgnoreCase("long")) {
                            ap.setItems((Property)new LongProperty());
                        }
                        if (header.getArrayType().equalsIgnoreCase("float")) {
                            ap.setItems((Property)new FloatProperty());
                        }
                        if (header.getArrayType().equalsIgnoreCase("double")) {
                            ap.setItems((Property)new DoubleProperty());
                        }
                        if (header.getArrayType().equalsIgnoreCase("boolean")) {
                            ap.setItems((Property)new BooleanProperty());
                        }
                    }
                    if (header.getExample() != null) {
                        ap.example((Object)header.getExample());
                    }
                    response.addHeader(name, (Property)ap);
                }
            }
            if (msg.getExamples() != null) {
                for (RestPropertyDefinition prop : msg.getExamples()) {
                    response.example(prop.getKey(), (Object)prop.getValue());
                }
            }
            op.addResponse(msg.getCode(), response);
        }
        if (op.getResponses() == null) {
            op.addResponse("200", new Response());
        }
    }

    private Model asModel(String typeName, Swagger swagger) {
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (swagger.getDefinitions() != null) {
            for (Model model : swagger.getDefinitions().values()) {
                StringProperty modelType = (StringProperty)model.getVendorExtensions().get("x-className");
                if (modelType == null || !typeName.equals(modelType.getFormat())) continue;
                return model;
            }
        }
        return null;
    }

    private String modelTypeAsRef(String typeName, Swagger swagger) {
        Model model;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((model = this.asModel(typeName, swagger)) != null) {
            typeName = ((ModelImpl)model).getName();
            return typeName;
        }
        return null;
    }

    private Property modelTypeAsProperty(String typeName, Swagger swagger) {
        Object prop;
        String ref;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((ref = this.modelTypeAsRef(typeName, swagger)) != null) {
            prop = new RefProperty(ref);
        } else if (array && ("byte".equals(typeName) || "java.lang.Byte".equals(typeName))) {
            prop = new ByteArrayProperty();
            array = false;
        } else {
            prop = "string".equalsIgnoreCase(typeName) || "java.lang.String".equals(typeName) ? new StringProperty() : ("int".equals(typeName) || "java.lang.Integer".equals(typeName) ? new IntegerProperty() : ("long".equals(typeName) || "java.lang.Long".equals(typeName) ? new LongProperty() : ("float".equals(typeName) || "java.lang.Float".equals(typeName) ? new FloatProperty() : ("double".equals(typeName) || "java.lang.Double".equals(typeName) ? new DoubleProperty() : ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName) ? new BooleanProperty() : new StringProperty(typeName))))));
        }
        if (array) {
            return new ArrayProperty((Property)prop);
        }
        return prop;
    }

    private void appendModels(Class clazz, Swagger swagger) {
        RestModelConverters converters = new RestModelConverters();
        Map<String, Model> models = converters.readClass(clazz);
        for (Map.Entry<String, Model> entry : models.entrySet()) {
            Model oldModel;
            boolean oldExt = false;
            if (swagger.getDefinitions() != null && swagger.getDefinitions().get(entry.getKey()) != null && (oldModel = (Model)swagger.getDefinitions().get(entry.getKey())).getVendorExtensions() != null && !oldModel.getVendorExtensions().isEmpty()) {
                boolean bl = oldExt = oldModel.getVendorExtensions().get("x-className") != null;
            }
            if (oldExt) continue;
            swagger.model(entry.getKey(), entry.getValue());
        }
    }

    private static class VerbOrdering
    implements Comparator<VerbDefinition> {
        private VerbOrdering() {
        }

        @Override
        public int compare(VerbDefinition a, VerbDefinition b) {
            int num;
            String u1 = "";
            if (a.getUri() != null) {
                u1 = a.getUri().replace("{", "_");
            }
            String u2 = "";
            if (b.getUri() != null) {
                u2 = b.getUri().replace("{", "_");
            }
            if ((num = u1.compareTo(u2)) == 0) {
                num = a.asVerb().compareTo(b.asVerb());
            }
            return num;
        }
    }
}

