/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.SwaggerParser;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Producer;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerRestProducerFactory
implements RestProducerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerRestProducerFactory.class);

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        Swagger swagger;
        Operation operation;
        String path;
        String apiDoc = (String)parameters.get("apiDoc");
        if (apiDoc == null) {
            throw new IllegalArgumentException("Swagger api-doc must be configured using the apiDoc option");
        }
        String string = path = uriTemplate != null ? uriTemplate : basePath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((operation = this.getSwaggerOperation(swagger = this.loadSwaggerModel(camelContext, apiDoc), verb, path)) == null) {
            throw new IllegalArgumentException("Swagger api-doc does not contain operation for " + verb + ":" + path);
        }
        if (queryParameters != null) {
            for (Parameter param : operation.getParameters()) {
                String key;
                String token;
                boolean hasQuery;
                if (!"query".equals(param.getIn()) || !param.getRequired() || (hasQuery = queryParameters.contains(token = (key = param.getName()) + "="))) continue;
                throw new IllegalArgumentException("Swagger api-doc does not contain query parameter " + key + " for " + verb + ":" + path);
            }
        }
        String componentName = (String)parameters.get("componentName");
        Producer producer = this.createHttpProducer(camelContext, swagger, operation, host, verb, path, queryParameters, produces, consumes, componentName, parameters);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Swagger loadSwaggerModel(CamelContext camelContext, String apiDoc) throws Exception {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)apiDoc);
        try {
            SwaggerParser parser = new SwaggerParser();
            String json = (String)camelContext.getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
            LOG.debug("Loaded swagger api-doc:\n{}", (Object)json);
            Swagger swagger = parser.parse(json);
            return swagger;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    private Operation getSwaggerOperation(Swagger swagger, String verb, String path) {
        Path modelPath;
        String basePath = swagger.getBasePath();
        if (basePath != null && path.startsWith(basePath)) {
            path = path.substring(basePath.length());
        }
        if ((modelPath = swagger.getPath(path)) == null) {
            return null;
        }
        Operation op = null;
        if ("get".equals(verb)) {
            op = modelPath.getGet();
        } else if ("put".equals(verb)) {
            op = modelPath.getPut();
        } else if ("post".equals(verb)) {
            op = modelPath.getPost();
        } else if ("head".equals(verb)) {
            op = modelPath.getHead();
        } else if ("delete".equals(verb)) {
            op = modelPath.getDelete();
        } else if ("patch".equals(verb)) {
            op = modelPath.getPatch();
        } else if ("options".equals(verb)) {
            op = modelPath.getOptions();
        }
        return op;
    }

    private Producer createHttpProducer(CamelContext camelContext, Swagger swagger, Operation operation, String host, String verb, String path, String queryParameters, String consumes, String produces, String componentName, Map<String, Object> parameters) throws Exception {
        LOG.debug("Using Swagger operation: {} with {} {}", new Object[]{operation, verb, path});
        RestProducerFactory factory = (RestProducerFactory)parameters.remove("restProducerFactory");
        if (factory != null) {
            String uriTemplate;
            String basePath;
            List list;
            CollectionStringBuffer csb;
            LOG.debug("Using RestProducerFactory: {}", (Object)factory);
            if (produces == null) {
                csb = new CollectionStringBuffer(",");
                list = operation.getProduces();
                if (list == null) {
                    list = swagger.getProduces();
                }
                if (list != null) {
                    for (String s : list) {
                        csb.append((Object)s);
                    }
                }
                String string = produces = csb.isEmpty() ? null : csb.toString();
            }
            if (consumes == null) {
                csb = new CollectionStringBuffer(",");
                list = operation.getConsumes();
                if (list == null) {
                    list = swagger.getConsumes();
                }
                if (list != null) {
                    for (String s : list) {
                        csb.append((Object)s);
                    }
                }
                String string = consumes = csb.isEmpty() ? null : csb.toString();
            }
            if (host == null) {
                host = swagger.getHost();
                basePath = swagger.getBasePath();
                uriTemplate = path;
            } else {
                basePath = path;
                uriTemplate = null;
            }
            RestConfiguration config = camelContext.getRestConfiguration(componentName, true);
            return factory.createProducer(camelContext, host, verb, basePath, uriTemplate, queryParameters, consumes, produces, config, parameters);
        }
        throw new IllegalStateException("Cannot find RestProducerFactory in Registry or as a Component to use");
    }
}

