/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public final class LazyStartProducer
extends DefaultAsyncProducer
implements DelegateProcessor {
    private volatile AsyncProducer delegate;

    public LazyStartProducer(Endpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block7: {
            try {
                if (this.delegate != null) break block7;
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate == null) {
                        AsyncProducer newDelegate = AsyncProcessorConverterHelper.convert(this.getEndpoint().createProducer());
                        if (!ServiceHelper.isStarted((Object)newDelegate)) {
                            ServiceHelper.startService((Service)newDelegate);
                        }
                        this.delegate = newDelegate;
                    }
                }
            }
            catch (Exception e) {
                this.delegate = null;
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        return this.delegate.process(exchange, callback);
    }

    @Override
    public boolean isSingleton() {
        if (this.delegate != null) {
            return this.delegate.isSingleton();
        }
        return this.getEndpoint().isSingleton();
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        ServiceHelper.stopService((Service)this.delegate);
    }

    protected void doSuspend() {
        ServiceHelper.suspendService((Object)this.delegate);
    }

    protected void doResume() {
        ServiceHelper.resumeService((Object)this.delegate);
    }

    protected void doShutdown() {
        ServiceHelper.stopAndShutdownService((Object)this.delegate);
    }

    public Processor getProcessor() {
        return this.delegate;
    }
}

