/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceResolverSupport
extends ServiceSupport
implements ResourceResolver {
    private final String scheme;
    private final Logger logger;
    private CamelContext camelContext;

    protected ResourceResolverSupport(String scheme) {
        this.scheme = scheme;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public String getSupportedScheme() {
        return this.scheme;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Resource resolve(String location) {
        if (!location.startsWith(this.getSupportedScheme() + ":")) {
            throw new IllegalArgumentException("Unsupported scheme: " + location);
        }
        String context = StringHelper.after((String)location, (String)":");
        if (context == null) {
            throw new IllegalArgumentException("No context path provided: " + location);
        }
        if (context.contains("{{") && context.contains("}}")) {
            context = this.camelContext.getPropertiesComponent().parseUri(context);
        }
        return this.createResource(location, context);
    }

    protected abstract Resource createResource(String var1, String var2);

    protected String getRemaining(String location) {
        return StringHelper.after((String)location, (String)(this.getSupportedScheme() + ":"));
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

