/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.camel.processor.idempotent.jdbc.AbstractJdbcMessageIdRepository;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

@Metadata(label="bean", description="Idempotent repository that uses a SQL database to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
public class JdbcMessageIdRepository
extends AbstractJdbcMessageIdRepository {
    protected static final String DEFAULT_TABLENAME = "CAMEL_MESSAGEPROCESSED";
    protected static final String DEFAULT_TABLE_EXISTS_STRING = "SELECT 1 FROM CAMEL_MESSAGEPROCESSED WHERE 1 = 0";
    protected static final String DEFAULT_CREATE_STRING = "CREATE TABLE CAMEL_MESSAGEPROCESSED (processorName VARCHAR(255), messageId VARCHAR(100), createdAt TIMESTAMP, PRIMARY KEY (processorName, messageId))";
    protected static final String DEFAULT_QUERY_STRING = "SELECT COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    protected static final String DEFAULT_INSERT_STRING = "INSERT INTO CAMEL_MESSAGEPROCESSED (processorName, messageId, createdAt) VALUES (?, ?, ?)";
    protected static final String DEFAULT_DELETE_STRING = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    protected static final String DEFAULT_CLEAR_STRING = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ?";
    @Metadata(description="The name of the table to use in the database", defaultValue="CAMEL_MESSAGEPROCESSED")
    private String tableName;
    @Metadata(description="Whether to create the table in the database if none exists on startup", defaultValue="true")
    private boolean createTableIfNotExists = true;
    @Metadata(label="advanced", description="SQL query to use for checking if table exists")
    private String tableExistsString = "SELECT 1 FROM CAMEL_MESSAGEPROCESSED WHERE 1 = 0";
    @Metadata(label="advanced", description="SQL query to use for creating table")
    private String createString = "CREATE TABLE CAMEL_MESSAGEPROCESSED (processorName VARCHAR(255), messageId VARCHAR(100), createdAt TIMESTAMP, PRIMARY KEY (processorName, messageId))";
    @Metadata(label="advanced", description="SQL query to use for check if message id already exists")
    private String queryString = "SELECT COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    @Metadata(label="advanced", description="SQL query to use for inserting a new message id in the table")
    private String insertString = "INSERT INTO CAMEL_MESSAGEPROCESSED (processorName, messageId, createdAt) VALUES (?, ?, ?)";
    @Metadata(label="advanced", description="SQL query to use for deleting message id from the table")
    private String deleteString = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    @Metadata(label="advanced", description="SQL query to delete all message ids from the table")
    private String clearString = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ?";

    public JdbcMessageIdRepository() {
    }

    public JdbcMessageIdRepository(DataSource dataSource, String processorName) {
        super(dataSource, processorName);
    }

    public JdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        super(dataSource, transactionTemplate, processorName);
    }

    public JdbcMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        super(jdbcTemplate, transactionTemplate);
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.tableName != null) {
            this.tableExistsString = DEFAULT_TABLE_EXISTS_STRING.replace(DEFAULT_TABLENAME, this.tableName);
            this.createString = DEFAULT_CREATE_STRING.replace(DEFAULT_TABLENAME, this.tableName);
            this.queryString = DEFAULT_QUERY_STRING.replace(DEFAULT_TABLENAME, this.tableName);
            this.insertString = DEFAULT_INSERT_STRING.replace(DEFAULT_TABLENAME, this.tableName);
            this.deleteString = DEFAULT_DELETE_STRING.replace(DEFAULT_TABLENAME, this.tableName);
            this.clearString = DEFAULT_CLEAR_STRING.replace(DEFAULT_TABLENAME, this.tableName);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        boolean tableExists = (Boolean)this.transactionTemplate.execute(status -> {
            try {
                this.jdbcTemplate.execute(this.getTableExistsString());
                this.log.debug("Expected table for JdbcMessageIdRepository exist");
                return true;
            }
            catch (DataAccessException e) {
                this.log.debug("Expected table for JdbcMessageIdRepository does not exist");
                return false;
            }
        });
        if (!tableExists && this.createTableIfNotExists) {
            this.transactionTemplate.executeWithoutResult(status -> {
                try {
                    this.log.debug("creating table for JdbcMessageIdRepository because it doesn't exist...");
                    this.jdbcTemplate.execute(this.getCreateString());
                    this.log.info("table created with query '{}'", (Object)this.getCreateString());
                }
                catch (DataAccessException dae) {
                    this.log.error("Can't create table for JdbcMessageIdRepository with query '{}' because of: {}. This may be a permissions problem. Please create this table and try again.", (Object)this.getCreateString(), (Object)dae.getMessage());
                    throw dae;
                }
            });
        }
    }

    @Override
    protected int queryForInt(String key) {
        return (Integer)this.jdbcTemplate.queryForObject(this.getQueryString(), Integer.class, new Object[]{this.processorName, key});
    }

    @Override
    protected int insert(String key) {
        return this.jdbcTemplate.update(this.getInsertString(), new Object[]{this.processorName, key, new Timestamp(System.currentTimeMillis())});
    }

    @Override
    protected int delete(String key) {
        return this.jdbcTemplate.update(this.getDeleteString(), new Object[]{this.processorName, key});
    }

    @Override
    protected int delete() {
        return this.jdbcTemplate.update(this.getClearString(), new Object[]{this.processorName});
    }

    public boolean isCreateTableIfNotExists() {
        return this.createTableIfNotExists;
    }

    public void setCreateTableIfNotExists(boolean createTableIfNotExists) {
        this.createTableIfNotExists = createTableIfNotExists;
    }

    public String getTableExistsString() {
        return this.tableExistsString;
    }

    public void setTableExistsString(String tableExistsString) {
        this.tableExistsString = tableExistsString;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCreateString() {
        return this.createString;
    }

    public void setCreateString(String createString) {
        this.createString = createString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getInsertString() {
        return this.insertString;
    }

    public void setInsertString(String insertString) {
        this.insertString = insertString;
    }

    public String getDeleteString() {
        return this.deleteString;
    }

    public void setDeleteString(String deleteString) {
        this.deleteString = deleteString;
    }

    public String getClearString() {
        return this.clearString;
    }

    public void setClearString(String clearString) {
        this.clearString = clearString;
    }
}

