/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.processor.idempotent.jdbc.JdbcMessageIdRepository;
import org.apache.camel.spi.ExecutorServiceManager;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcOrphanLockAwareIdempotentRepository
extends JdbcMessageIdRepository {
    private final StampedLock sl = new StampedLock();
    private final Set<ProcessorNameAndMessageId> processorNameMessageIdSet = new HashSet<ProcessorNameAndMessageId>();
    private ExecutorServiceManager executorServiceManager;
    private ScheduledExecutorService executorService;
    private CamelContext context;
    private long lockMaxAgeMillis;
    private long lockKeepAliveIntervalMillis;
    private String updateTimestampQuery = "UPDATE CAMEL_MESSAGEPROCESSED SET createdAt =? WHERE processorName =? AND messageId = ?";

    public JdbcOrphanLockAwareIdempotentRepository(CamelContext camelContext) {
        this.context = camelContext;
    }

    public JdbcOrphanLockAwareIdempotentRepository(DataSource dataSource, String processorName, CamelContext camelContext) {
        super(dataSource, processorName);
        this.context = camelContext;
    }

    public JdbcOrphanLockAwareIdempotentRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName, CamelContext camelContext) {
        super(dataSource, transactionTemplate, processorName);
        this.context = camelContext;
    }

    public JdbcOrphanLockAwareIdempotentRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, CamelContext camelContext) {
        super(jdbcTemplate, transactionTemplate);
        this.context = camelContext;
    }

    @Override
    protected int queryForInt(String key) {
        String orphanLockRecoverQueryString = this.getQueryString() + " AND createdAt >= ?";
        Timestamp xMillisAgo = new Timestamp(System.currentTimeMillis() - this.lockMaxAgeMillis);
        return (Integer)this.jdbcTemplate.queryForObject(orphanLockRecoverQueryString, Integer.class, new Object[]{this.processorName, key, xMillisAgo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int delete(String key) {
        long stamp = this.sl.writeLock();
        try {
            int result = super.delete(key);
            this.processorNameMessageIdSet.remove(new ProcessorNameAndMessageId(this.processorName, key));
            int n = result;
            return n;
        }
        finally {
            this.sl.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int insert(String key) {
        Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
        long stamp = this.sl.writeLock();
        try {
            if ((Integer)this.jdbcTemplate.queryForObject(this.getQueryString(), Integer.class, new Object[]{this.processorName, key}) == 0) {
                int result = this.jdbcTemplate.update(this.getInsertString(), new Object[]{this.processorName, key, currentTimestamp});
                this.processorNameMessageIdSet.add(new ProcessorNameAndMessageId(this.processorName, key));
                int n = result;
                return n;
            }
            int n = this.jdbcTemplate.update(this.getUpdateTimestampQuery(), new Object[]{currentTimestamp, this.processorName, key});
            return n;
        }
        finally {
            this.sl.unlockWrite(stamp);
        }
    }

    @Override
    protected void doInit() throws Exception {
        if (this.lockMaxAgeMillis <= this.lockKeepAliveIntervalMillis) {
            throw new IllegalStateException("value of lockMaxAgeMillis cannot be <= lockKeepAliveIntervalMillis");
        }
        Objects.requireNonNull(this.context, () -> "context cannot be null");
        super.doInit();
        if (this.getTableName() != null) {
            this.updateTimestampQuery = this.updateTimestampQuery.replaceFirst("CAMEL_MESSAGEPROCESSED", this.getTableName());
        }
        this.executorServiceManager = this.context.getExecutorServiceManager();
        this.executorService = this.executorServiceManager.newSingleThreadScheduledExecutor((Object)this, ((Object)((Object)this)).getClass().getSimpleName());
        this.executorService.scheduleWithFixedDelay(new LockKeepAliveTask(), this.lockKeepAliveIntervalMillis, this.lockKeepAliveIntervalMillis, TimeUnit.MILLISECONDS);
    }

    protected void doShutdown() throws Exception {
        if (this.executorServiceManager != null && this.executorService != null) {
            this.executorServiceManager.shutdownGraceful((ExecutorService)this.executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int delete() {
        long stamp = this.sl.writeLock();
        try {
            int result = super.delete();
            this.processorNameMessageIdSet.clear();
            int n = result;
            return n;
        }
        finally {
            this.sl.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepAlive() {
        Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
        long stamp = this.sl.readLock();
        try {
            List args = this.processorNameMessageIdSet.stream().map(processorNameMessageId -> new Object[]{currentTimestamp, processorNameMessageId.processorName, processorNameMessageId.messageId}).collect(Collectors.toList());
            this.transactionTemplate.execute(status -> this.jdbcTemplate.batchUpdate(this.getUpdateTimestampQuery(), args));
        }
        catch (Exception e) {
            this.log.error("failed updating createdAt in keepAlive due to ", (Throwable)e);
        }
        finally {
            this.sl.unlockRead(stamp);
        }
    }

    public Set<ProcessorNameAndMessageId> getProcessorNameMessageIdSet() {
        return this.processorNameMessageIdSet;
    }

    public String getUpdateTimestampQuery() {
        return this.updateTimestampQuery;
    }

    public void setUpdateTimestampQuery(String updateTimestampQuery) {
        this.updateTimestampQuery = updateTimestampQuery;
    }

    public long getLockMaxAgeMillis() {
        return this.lockMaxAgeMillis;
    }

    public void setLockMaxAgeMillis(long lockMaxAgeMillis) {
        this.lockMaxAgeMillis = lockMaxAgeMillis;
    }

    public long getLockKeepAliveIntervalMillis() {
        return this.lockKeepAliveIntervalMillis;
    }

    public void setLockKeepAliveIntervalMillis(long lockKeepAliveIntervalMillis) {
        this.lockKeepAliveIntervalMillis = lockKeepAliveIntervalMillis;
    }

    static class ProcessorNameAndMessageId {
        private final String processorName;
        private final String messageId;

        public ProcessorNameAndMessageId(String processorName, String messageId) {
            this.processorName = processorName;
            this.messageId = messageId;
        }

        public String getProcessorName() {
            return this.processorName;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            result = 31 * result + (this.processorName == null ? 0 : this.processorName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessorNameAndMessageId other = (ProcessorNameAndMessageId)obj;
            if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
                return false;
            }
            return !(this.processorName == null ? other.processorName != null : !this.processorName.equals(other.processorName));
        }
    }

    class LockKeepAliveTask
    implements Runnable {
        LockKeepAliveTask() {
        }

        @Override
        public void run() {
            JdbcOrphanLockAwareIdempotentRepository.this.keepAlive();
        }
    }
}

