/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlComponent
extends UriEndpointComponent {
    private DataSource dataSource;
    @Metadata(defaultValue="true")
    private boolean usePlaceholder = true;

    public SqlComponent() {
        super(SqlEndpoint.class);
    }

    public SqlComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public SqlComponent(CamelContext context) {
        super(context, SqlEndpoint.class);
    }

    public SqlComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context, endpointClass);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String onConsumeBatchComplete;
        String onConsumeFailed;
        DataSource target = null;
        DataSource ds = (DataSource)this.resolveAndRemoveReferenceParameter(parameters, "dataSource", DataSource.class);
        if (ds != null) {
            target = ds;
        }
        String dataSourceRef = (String)this.getAndRemoveParameter(parameters, "dataSourceRef", String.class);
        if (target == null && dataSourceRef != null) {
            target = (DataSource)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)dataSourceRef, DataSource.class);
        }
        if (target == null) {
            target = this.dataSource;
        }
        if (target == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        String parameterPlaceholderSubstitute = (String)this.getAndRemoveParameter(parameters, "placeholder", String.class, "#");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(target);
        IntrospectionSupport.setProperties((Object)jdbcTemplate, parameters, (String)"template.");
        String query = remaining.replaceAll(parameterPlaceholderSubstitute, "?");
        String onConsume = (String)this.getAndRemoveParameter(parameters, "consumer.onConsume", String.class);
        if (onConsume == null) {
            onConsume = (String)this.getAndRemoveParameter(parameters, "onConsume", String.class);
        }
        if (onConsume != null && this.usePlaceholder) {
            onConsume = onConsume.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeFailed", String.class)) == null) {
            onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "onConsumeFailed", String.class);
        }
        if (onConsumeFailed != null && this.usePlaceholder) {
            onConsumeFailed = onConsumeFailed.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeBatchComplete", String.class)) == null) {
            onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "onConsumeBatchComplete", String.class);
        }
        if (onConsumeBatchComplete != null && this.usePlaceholder) {
            onConsumeBatchComplete = onConsumeBatchComplete.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        SqlEndpoint endpoint = new SqlEndpoint(uri, (Component)this, jdbcTemplate, query);
        endpoint.setOnConsume(onConsume);
        endpoint.setOnConsumeFailed(onConsumeFailed);
        endpoint.setOnConsumeBatchComplete(onConsumeBatchComplete);
        endpoint.setDataSource(ds);
        endpoint.setDataSourceRef(dataSourceRef);
        return endpoint;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUsePlaceholder(boolean usePlaceholder) {
        this.usePlaceholder = usePlaceholder;
    }

    public boolean isUsePlaceholder() {
        return this.usePlaceholder;
    }
}

