/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlProducer
extends DefaultProducer<DefaultExchange> {
    private String query;
    private JdbcTemplate jdbcTemplate;

    public SqlProducer(SqlEndpoint endpoint, String query, JdbcTemplate jdbcTemplate) {
        super((Endpoint)endpoint);
        this.jdbcTemplate = jdbcTemplate;
        this.query = query;
    }

    public void process(Exchange exchange) throws Exception {
        ArrayList arguments = new ArrayList();
        Iterator i = (Iterator)exchange.getIn().getBody(Iterator.class);
        while (i.hasNext()) {
            arguments.add(i.next());
        }
        List result = this.jdbcTemplate.queryForList(this.query, arguments.toArray());
        exchange.getOut().setBody((Object)result);
    }
}

