/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainSupport;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Main
extends MainCommandLineSupport {
    public static final String LOCATION_PROPERTIES = "META-INF/camel-spring/location.properties";
    protected static Main instance;
    private static final Charset UTF8;
    private String applicationContextUri = "META-INF/spring/*.xml";
    private String fileApplicationContextUri;
    private AbstractApplicationContext applicationContext;
    private AbstractApplicationContext parentApplicationContext;
    private AbstractApplicationContext additionalApplicationContext;
    private String parentApplicationContextUri;

    public Main() {
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("ac", "applicationContext", "Sets the classpath based spring ApplicationContext", "applicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based spring ApplicationContext", "fileApplicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setFileApplicationContextUri(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public AbstractApplicationContext getParentApplicationContext() {
        if (this.parentApplicationContext == null && this.parentApplicationContextUri != null) {
            this.parentApplicationContext = new ClassPathXmlApplicationContext(this.parentApplicationContextUri);
            this.parentApplicationContext.start();
        }
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(AbstractApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public String getParentApplicationContextUri() {
        return this.parentApplicationContextUri;
    }

    public void setParentApplicationContextUri(String parentApplicationContextUri) {
        this.parentApplicationContextUri = parentApplicationContextUri;
    }

    protected CamelContext createCamelContext() {
        Map camels = this.applicationContext.getBeansOfType(SpringCamelContext.class);
        if (camels.size() > 1) {
            throw new IllegalArgumentException("Multiple CamelContext detected. This Main class only supports single CamelContext");
        }
        if (camels.size() == 1) {
            return (CamelContext)camels.values().iterator().next();
        }
        return null;
    }

    protected void doStart() throws Exception {
        try {
            super.doStart();
            if (this.applicationContext == null) {
                this.applicationContext = this.createDefaultApplicationContext();
            }
            if (this.additionalApplicationContext == null) {
                this.additionalApplicationContext = this.createAdditionalLocationsFromClasspath();
                if (this.additionalApplicationContext != null) {
                    LOG.debug("Starting Additional ApplicationContext: {}", (Object)this.additionalApplicationContext.getId());
                    this.additionalApplicationContext.start();
                }
            }
            LOG.debug("Starting Spring ApplicationContext: {}", (Object)this.applicationContext.getId());
            this.applicationContext.start();
            this.initCamelContext();
        }
        finally {
            if (this.getCamelContext() != null && this.getCamelContext().isVetoStarted()) {
                this.completed();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.additionalApplicationContext != null) {
            LOG.debug("Stopping Additional ApplicationContext: {}", (Object)this.additionalApplicationContext.getId());
            IOHelper.close((Closeable)this.additionalApplicationContext);
        }
        if (this.applicationContext != null) {
            LOG.debug("Stopping Spring ApplicationContext: {}", (Object)this.applicationContext.getId());
            IOHelper.close((Closeable)this.applicationContext);
        }
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        String[] names = this.getApplicationContext().getBeanNamesForType(ProducerTemplate.class);
        if (names != null && names.length > 0) {
            return (ProducerTemplate)this.getApplicationContext().getBean(names[0], ProducerTemplate.class);
        }
        if (this.getCamelContext() == null) {
            throw new IllegalArgumentException("No CamelContext are available so cannot create a ProducerTemplate!");
        }
        return this.getCamelContext().createProducerTemplate();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() throws IOException {
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        if (this.getFileApplicationContextUri() != null) {
            String[] args = this.getFileApplicationContextUri().split(";");
            if (parentContext != null) {
                return new FileSystemXmlApplicationContext(args, (ApplicationContext)parentContext);
            }
            return new FileSystemXmlApplicationContext(args);
        }
        String[] args = this.getApplicationContextUri().split(";");
        if (parentContext != null) {
            return new ClassPathXmlApplicationContext(args, (ApplicationContext)parentContext);
        }
        if (this.routeBuilderClasses != null) {
            String[] classes;
            AnnotationConfigApplicationContext ac = new AnnotationConfigApplicationContext();
            ac.register(new Class[]{SpringCamelContext.class});
            LinkedHashSet<String> packages = new LinkedHashSet<String>();
            for (String clazz : classes = this.routeBuilderClasses.split(",")) {
                if (!clazz.contains(".")) continue;
                String packageName = clazz.substring(0, clazz.lastIndexOf("."));
                packages.add(packageName);
            }
            LOG.info("Using Spring annotation scanning in packages: {}", packages);
            ac.scan(packages.toArray(new String[packages.size()]));
            ac.refresh();
            return ac;
        }
        return new ClassPathXmlApplicationContext(args);
    }

    protected AbstractApplicationContext createAdditionalLocationsFromClasspath() throws IOException {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        this.findLocations(locations, Main.class.getClassLoader());
        if (!locations.isEmpty()) {
            LOG.info("Found locations for additional Spring XML files: {}", locations);
            String[] locs = locations.toArray(new String[locations.size()]);
            return new ClassPathXmlApplicationContext(locs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findLocations(Set<String> locations, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(LOCATION_PROPERTIES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), UTF8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    locations.add(line);
                }
            }
            finally {
                IOHelper.close((Closeable)reader, null, (Logger)LOG);
            }
        }
    }

    static {
        UTF8 = Charset.forName("UTF-8");
    }
}

