/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.Map;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.xml.ResultHandlerFactory;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(XsltComponent.class);
    private XmlConverter xmlConverter;
    private URIResolver uriResolver;
    private boolean contentCache = true;

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean failOnNullBody;
        URIResolver resolver;
        String resourceUri = remaining;
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        XsltBuilder xslt = (XsltBuilder)this.getCamelContext().getInjector().newInstance(XsltBuilder.class);
        XmlConverter converter = (XmlConverter)this.resolveAndRemoveReferenceParameter(parameters, "converter", XmlConverter.class);
        if (converter == null) {
            converter = this.getXmlConverter();
        }
        if (converter != null) {
            xslt.setConverter(converter);
        }
        String transformerFactoryClassName = (String)this.getAndRemoveParameter(parameters, "transformerFactoryClass", String.class);
        TransformerFactory factory = null;
        if (transformerFactoryClassName != null) {
            Class factoryClass = this.getCamelContext().getClassResolver().resolveClass(transformerFactoryClassName, XsltComponent.class.getClassLoader());
            if (factoryClass != null) {
                factory = (TransformerFactory)this.getCamelContext().getInjector().newInstance(factoryClass);
            } else {
                LOG.warn("Cannot find the TransformerFactoryClass with the class name: {}", (Object)transformerFactoryClassName);
            }
        }
        if (parameters.get("transformerFactory") != null) {
            factory = (TransformerFactory)this.resolveAndRemoveReferenceParameter(parameters, "transformerFactory", TransformerFactory.class);
        }
        if (factory != null) {
            xslt.getConverter().setTransformerFactory(factory);
        }
        if ((resolver = (URIResolver)this.resolveAndRemoveReferenceParameter(parameters, "uriResolver", URIResolver.class)) == null) {
            resolver = this.getUriResolver();
        }
        if (resolver == null) {
            resolver = new XsltUriResolver(this.getCamelContext().getClassResolver(), remaining);
        }
        xslt.setUriResolver(resolver);
        ResultHandlerFactory resultHandlerFactory = (ResultHandlerFactory)this.resolveAndRemoveReferenceParameter(parameters, "resultHandlerFactory", ResultHandlerFactory.class);
        if (resultHandlerFactory != null) {
            xslt.setResultHandlerFactory(resultHandlerFactory);
        }
        if ((failOnNullBody = (Boolean)this.getAndRemoveParameter(parameters, "failOnNullBody", Boolean.class)) != null) {
            xslt.setFailOnNullBody(failOnNullBody.booleanValue());
        }
        String output = (String)this.getAndRemoveParameter(parameters, "output", String.class);
        this.configureOutput(xslt, output);
        this.configureXslt(xslt, uri, remaining, parameters);
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        return new XsltEndpoint(uri, (Component)this, xslt, resourceUri, cache);
    }

    protected void configureXslt(XsltBuilder xslt, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xslt, parameters);
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty((Object)output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }
}

