/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.util.URISupport;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelEndpointFactoryBean
extends AbstractCamelFactoryBean<Endpoint> {
    @XmlAttribute(required=false)
    @Deprecated
    private Boolean singleton;
    @XmlAttribute(required=true)
    private String uri;
    @XmlAttribute
    @Deprecated
    private ExchangePattern pattern;
    @XmlElementRef
    private List<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
    @XmlTransient
    private Endpoint endpoint;

    @Override
    public Endpoint getObject() throws Exception {
        if (this.endpoint == null || !this.endpoint.isSingleton()) {
            String target = this.createUri();
            this.endpoint = this.getCamelContext().getEndpoint(target);
            if (this.endpoint == null) {
                throw new NoSuchEndpointException(target);
            }
        }
        return this.endpoint;
    }

    @Override
    public Class<Endpoint> getObjectType() {
        return Endpoint.class;
    }

    @Deprecated
    public Boolean getSingleton() {
        return this.singleton;
    }

    @Deprecated
    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Deprecated
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    private String createUri() throws UnsupportedEncodingException, URISyntaxException {
        if (this.properties == null || this.properties.isEmpty()) {
            return this.uri;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (PropertyDefinition property : this.properties) {
            map.put(property.getKey(), property.getValue());
        }
        return URISupport.appendParametersToURI((String)this.uri, map);
    }
}

