/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ResolverUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilderFinder {
    private static final transient Log LOG = LogFactory.getLog(RouteBuilderFinder.class);
    private final SpringCamelContext camelContext;
    private final String[] packages;
    private ApplicationContext applicationContext;
    private ResolverUtil resolver = new ResolverUtil();
    private BeanPostProcessor beanPostProcessor;

    public RouteBuilderFinder(SpringCamelContext camelContext, String[] packages, ClassLoader classLoader, BeanPostProcessor postProcessor) {
        this.camelContext = camelContext;
        this.applicationContext = camelContext.getApplicationContext();
        this.packages = packages;
        this.beanPostProcessor = postProcessor;
        Set set = this.resolver.getClassLoaders();
        set.clear();
        set.add(classLoader);
    }

    public String[] getPackages() {
        return this.packages;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void appendBuilders(List<RouteBuilder> list) throws IllegalAccessException, InstantiationException {
        this.resolver.findImplementations(RouteBuilder.class, this.packages);
        Set classes = this.resolver.getClasses();
        for (Class aClass : classes) {
            if (this.shouldIgnoreBean(aClass) || !this.isValidClass(aClass)) continue;
            RouteBuilder builder = this.instantiateBuilder(aClass);
            if (this.beanPostProcessor != null) {
                this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
            }
            list.add(builder);
        }
    }

    public void destroy() throws Exception {
    }

    protected boolean shouldIgnoreBean(Class type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isValidClass(Class type) {
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RouteBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RouteBuilder)this.camelContext.getInjector().newInstance(type);
    }
}

