/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.pojo.PojoComponent;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class CamelProxyFactoryBean
extends UrlBasedRemoteAccessor
implements FactoryBean {
    private CamelContext camelContext;
    private Endpoint endpoint;
    private Object serviceProxy;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            if (this.endpoint == null) {
                if (this.getServiceUrl() == null || this.camelContext == null) {
                    throw new IllegalArgumentException("If endpoint is not specified, the serviceUrl and camelContext must be specified.");
                }
                this.endpoint = this.camelContext.getEndpoint(this.getServiceUrl());
                if (this.endpoint == null) {
                    throw new IllegalArgumentException("Could not resolve endpoint: " + this.getServiceUrl());
                }
            }
            this.serviceProxy = PojoComponent.createProxy((Endpoint)this.endpoint, (Class)this.getServiceInterface());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

