/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.util.ResolverUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilderFinder
implements ApplicationContextAware {
    private String[] packages = new String[0];
    private ApplicationContext applicationContext;
    private ResolverUtil resolver = new ResolverUtil();

    public RouteBuilderFinder(ApplicationContext applicationContext, String[] packages) {
        this.applicationContext = applicationContext;
        this.packages = packages;
    }

    public RouteBuilderFinder(CamelContextFactoryBean factoryBean) {
        this.applicationContext = factoryBean.getApplicationContext();
        this.packages = factoryBean.getPackages();
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void appendBuilders(List<RouteBuilder> list) throws IllegalAccessException, InstantiationException {
        this.resolver.findImplementations(RouteBuilder.class, this.packages);
        Set classes = this.resolver.getClasses();
        for (Class aClass : classes) {
            if (this.shouldIgnoreBean(aClass) || !this.isValidClass(aClass)) continue;
            list.add(this.instantiateBuilder(aClass));
        }
    }

    public void destroy() throws Exception {
    }

    protected boolean shouldIgnoreBean(Class type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isValidClass(Class type) {
        if (!Modifier.isAbstract(type.getModifiers()) && !type.isInterface()) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = type.getDeclaredConstructors()) {
                Class<?>[] classes = constructor.getParameterTypes();
                if (classes.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected RouteBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RouteBuilder)type.newInstance();
    }
}

