/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.StopWatch;
import org.springframework.context.ApplicationContext;

public class SpringBootCamelContext
extends SpringCamelContext {
    private final StopWatch stopWatch = new StopWatch();
    private final boolean warnOnEarlyShutdown;

    public SpringBootCamelContext(ApplicationContext applicationContext, boolean warnOnEarlyShutdown) {
        super(applicationContext);
        this.warnOnEarlyShutdown = warnOnEarlyShutdown;
    }

    protected void doStart() throws Exception {
        this.stopWatch.restart();
        super.doStart();
    }

    protected synchronized void doStop() throws Exception {
        long taken = this.stopWatch.taken();
        if (this.warnOnEarlyShutdown && taken < 1200L) {
            boolean starterWeb;
            String cp = System.getProperty("java.class.path");
            boolean junit = cp != null && cp.contains("junit-");
            boolean bl = starterWeb = cp != null && cp.contains("spring-boot-starter-web");
            if (!junit && !starterWeb) {
                this.log.warn("CamelContext has only been running for less than a second. If you intend to run Camel for a longer time then you can set the property camel.springboot.main-run-controller=true in application.properties or add spring-boot-starter-web JAR to the classpath.");
            }
        }
        super.doStop();
    }
}

