/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spring.batch.SpringBatchConstants;
import org.apache.camel.component.spring.batch.SpringBatchProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

@UriEndpoint(firstVersion="2.10.0", scheme="spring-batch", title="Spring Batch", syntax="spring-batch:jobName", remote=false, producerOnly=true, headersClass=SpringBatchConstants.class, category={Category.WORKFLOW})
public class SpringBatchEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String jobName;
    @UriParam
    private boolean jobFromHeader;
    @UriParam
    private JobLauncher jobLauncher;
    @UriParam
    private JobRegistry jobRegistry;
    private Job job;

    public SpringBatchEndpoint(String endpointUri, Component component, JobLauncher jobLauncher, String jobName, JobRegistry jobRegistry) {
        super(endpointUri, component);
        this.jobLauncher = jobLauncher;
        this.jobName = jobName;
        this.jobRegistry = jobRegistry;
    }

    public boolean isRemote() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new SpringBatchProducer(this, this.jobLauncher, this.job, this.jobRegistry);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.jobLauncher == null) {
            this.jobLauncher = (JobLauncher)CamelContextHelper.mandatoryFindSingleByType((CamelContext)this.getCamelContext(), JobLauncher.class);
        }
        if (this.job == null && this.jobName != null && !this.jobFromHeader) {
            if (this.jobRegistry != null) {
                this.job = this.jobRegistry.getJob(this.jobName);
            }
            if (this.job == null) {
                this.job = (Job)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.jobName, Job.class);
            }
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setJobFromHeader(boolean jobFromHeader) {
        this.jobFromHeader = jobFromHeader;
    }

    public boolean isJobFromHeader() {
        return this.jobFromHeader;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

