/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;
import org.apache.camel.parser.roaster.StatementFieldSource;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public final class ParserCommon {
    private ParserCommon() {
    }

    public static Expression evalExpression(Expression exp) {
        if (exp instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)exp;
            exp = singleMemberAnnotation.getValue();
        } else if (exp instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)exp;
            List values = normalAnnotation.values();
            for (Object value : values) {
                MemberValuePair pair = (MemberValuePair)value;
                if (!"uri".equals(pair.getName().toString())) continue;
                exp = pair.getValue();
                break;
            }
        }
        return exp;
    }

    static FieldSource<JavaClassSource> findFieldInBlock(JavaClassSource clazz, Block block, String fieldName) {
        for (Object statement : block.statements()) {
            ASTNode node;
            if (statement instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
                Type type = variableDeclarationStatement.getType();
                for (Object obj : variableDeclarationStatement.fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource<JavaClassSource>(clazz, fragment, type);
                }
            }
            if ((node = block.getParent()) instanceof MethodDeclaration) {
                node = node.getParent();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            List declarations = ((AnonymousClassDeclaration)node).bodyDeclarations();
            for (Object dec : declarations) {
                if (!(dec instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)dec;
                Type type = fd.getType();
                for (Object obj : fd.fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource<JavaClassSource>(clazz, fragment, type);
                }
            }
        }
        return null;
    }

    static FieldSource<JavaClassSource> getField(JavaClassSource clazz, Block block, SimpleName ref) {
        String fieldName = ref.getIdentifier();
        if (fieldName != null) {
            FieldSource<JavaClassSource> field;
            FieldSource<JavaClassSource> fieldSource = field = clazz != null ? clazz.getField(fieldName) : null;
            if (field == null) {
                field = ParserCommon.findFieldInBlock(clazz, block, fieldName);
            }
            return field;
        }
        return null;
    }

    public static boolean isNumericOperator(JavaClassSource clazz, Block block, Expression expression) {
        FieldSource<JavaClassSource> field;
        if (expression instanceof NumberLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (field = ParserCommon.getField(clazz, block, (SimpleName)expression)) != null) {
            return field.getType().isType("int") || field.getType().isType("long") || field.getType().isType("Integer") || field.getType().isType("Long");
        }
        return false;
    }

    public static boolean isCommonPredicate(String name) {
        if (name.equals("completionPredicate") || name.equals("completion")) {
            return true;
        }
        if (name.equals("onWhen") || name.equals("when") || name.equals("handled") || name.equals("continued")) {
            return true;
        }
        return name.equals("retryWhile") || name.equals("filter") || name.equals("validate") || name.equals("loopDoWhile");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int findLineNumber(String fullyQualifiedFileName, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(fullyQualifiedFileName));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }
}

