/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.printer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.DocAttributeSet;

class PrintDocument
implements Doc {
    private final Lock lock = new ReentrantLock();
    private DocFlavor docFlavor;
    private InputStream stream;
    private Reader reader;
    private byte[] buffer;

    PrintDocument(InputStream stream, DocFlavor docFlavor) {
        this.stream = stream;
        this.docFlavor = docFlavor;
    }

    @Override
    public DocFlavor getDocFlavor() {
        return this.docFlavor;
    }

    @Override
    public DocAttributeSet getAttributes() {
        return null;
    }

    @Override
    public Object getPrintData() throws IOException {
        return this.getStreamForBytes();
    }

    @Override
    public Reader getReaderForText() throws IOException {
        this.lock.lock();
        try {
            if (this.reader != null) {
                Reader reader = this.reader;
                return reader;
            }
            if (this.docFlavor.getMediaType().equalsIgnoreCase("image")) {
                this.reader = null;
            } else if (this.docFlavor.getMediaType().equalsIgnoreCase("text") || this.docFlavor.getMediaType().equalsIgnoreCase("application") && this.docFlavor.getMediaSubtype().equalsIgnoreCase("xml")) {
                this.buffer = new byte[this.stream.available()];
                int n = this.stream.available();
                for (int i = 0; i < n; ++i) {
                    this.buffer[i] = (byte)this.stream.read();
                }
                this.reader = new StringReader(new String(this.buffer));
                this.stream = new ByteArrayInputStream(this.buffer);
            }
            Reader reader = this.reader;
            return reader;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public InputStream getStreamForBytes() throws IOException {
        return this.stream;
    }
}

