/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.printer;

import java.io.InputStream;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.printer.PrintDocument;
import org.apache.camel.component.printer.PrinterConfiguration;
import org.apache.camel.component.printer.PrinterOperations;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class PrinterProducer
extends DefaultProducer {
    private final PrinterConfiguration config;
    private PrinterOperations printerOperations;
    private PrintService printService;
    private String printer;

    public PrinterProducer(Endpoint endpoint, PrinterConfiguration config) throws Exception {
        super(endpoint);
        this.config = config;
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, body);
        String jobName = (String)exchange.getIn().getHeader("PrinterJobName", (Object)"Camel: lpr", String.class);
        this.print(is, jobName);
    }

    private void print(InputStream body, String jobName) throws PrintException {
        if (this.printerOperations.getPrintService().isDocFlavorSupported(this.printerOperations.getFlavor())) {
            PrintDocument printDoc = new PrintDocument(body, this.printerOperations.getFlavor());
            this.printerOperations.print(printDoc, this.config.getCopies(), this.config.isSendToPrinter(), this.config.getMimeType(), jobName);
        }
    }

    private DocFlavor assignDocFlavor() throws Exception {
        return this.config.getDocFlavor();
    }

    private PrintRequestAttributeSet assignPrintAttributes() throws PrintException {
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (this.config.getCopies() < 1) {
            throw new PrintException("Number of print copies should be greater than zero");
        }
        printRequestAttributeSet.add(new Copies(this.config.getCopies()));
        printRequestAttributeSet.add(this.config.getMediaSizeName());
        printRequestAttributeSet.add(this.config.getInternalSides());
        return printRequestAttributeSet;
    }

    private PrintService assignPrintService() throws PrintException {
        PrintService printService;
        if (this.config.getHostname().equalsIgnoreCase("localhost") && this.config.getPrintername().equalsIgnoreCase("default")) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        } else {
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            String name = this.config.getHostname().equalsIgnoreCase("localhost") ? this.config.getPrintername() : "\\\\" + this.config.getHostname() + "\\" + this.config.getPrintername();
            this.log.debug("Using printer name: {}", (Object)name);
            this.setPrinter(name);
            int position = this.findPrinter(services, this.printer);
            if (position < 0) {
                throw new PrintException("No printer found with name: " + this.printer + ". Please verify that the host and printer are registered and reachable from this machine.");
            }
            printService = services[position];
        }
        return printService;
    }

    private int findPrinter(PrintService[] services, String printer) {
        int position = -1;
        for (int i = 0; i < services.length; ++i) {
            if (!printer.equalsIgnoreCase(services[i].getName())) continue;
            position = i;
            break;
        }
        return position;
    }

    public PrinterConfiguration getConfig() {
        return this.config;
    }

    public PrinterOperations getPrinterOperations() {
        return this.printerOperations;
    }

    public void setPrinterOperations(PrinterOperations printerOperations) {
        this.printerOperations = printerOperations;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    protected void doStart() throws Exception {
        if (this.printService == null) {
            this.printService = this.assignPrintService();
        }
        ObjectHelper.notNull((Object)this.printService, (String)"PrintService", (Object)((Object)this));
        if (this.printerOperations == null) {
            this.printerOperations = new PrinterOperations(this.printService, this.assignDocFlavor(), this.assignPrintAttributes());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

