/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.DefaultPlatformHttpConsumer;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.PlatformHttpListener;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestOpenApiConsumerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="platform-http")
public class PlatformHttpComponent
extends HeaderFilterStrategyComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestOpenApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformHttpComponent.class);
    @Metadata(label="advanced", description="An HTTP Server engine implementation to serve the requests")
    private volatile PlatformHttpEngine engine;
    @Metadata(label="advanced,consumer", defaultValue="false", description="When Camel is complete processing the message, and the HTTP server is writing response. This option controls whether Camel should catch any failure during writing response and store this on the Exchange, which allows onCompletion/UnitOfWork to regard the Exchange as failed and have access to the caused exception from the HTTP server.")
    private boolean handleWriteResponseError;
    @Metadata(label="advanced,consumer", description="The period in milliseconds after which the request should be timed out.")
    private long requestTimeout;
    private final Set<HttpEndpointModel> httpEndpoints = new TreeSet<HttpEndpointModel>();
    private final List<PlatformHttpListener> listeners = new ArrayList<PlatformHttpListener>();
    private volatile boolean localEngine;

    public PlatformHttpComponent() {
        this(null);
    }

    public PlatformHttpComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PlatformHttpEndpoint endpoint = new PlatformHttpEndpoint(uri, remaining, (Component)this);
        endpoint.setPlatformHttpEngine(this.engine);
        endpoint.setHandleWriteResponseError(this.handleWriteResponseError);
        endpoint.setRequestTimeout(this.requestTimeout);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, "application/json,text/yaml", configuration, parameters, true, true);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false, true);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, null, contextPath, null, null, null, configuration, parameters, true, false);
    }

    public void addHttpEndpoint(String uri, String verbs, String consumes, String produces, Consumer consumer) {
        HttpEndpointModel model = new HttpEndpointModel(uri, verbs, consumes, produces, consumer);
        this.httpEndpoints.add(model);
        for (PlatformHttpListener listener : this.listeners) {
            try {
                listener.registerHttpEndpoint(model);
            }
            catch (Exception e) {
                LOG.warn("Error adding listener due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void removeHttpEndpoint(String uri) {
        ArrayList toRemove = new ArrayList();
        this.httpEndpoints.stream().filter(e -> e.getUri().equals(uri)).forEach(model -> {
            toRemove.add(model);
            for (PlatformHttpListener listener : this.listeners) {
                try {
                    listener.unregisterHttpEndpoint((HttpEndpointModel)model);
                }
                catch (Exception e) {
                    LOG.warn("Error removing listener due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
                }
            }
        });
        toRemove.forEach(this.httpEndpoints::remove);
    }

    public void addPlatformHttpListener(PlatformHttpListener listener) {
        this.listeners.add(listener);
    }

    public void removePlatformHttpListener(PlatformHttpListener listener) {
        this.listeners.remove(listener);
    }

    public Set<HttpEndpointModel> getHttpEndpoints() {
        return Collections.unmodifiableSet(this.httpEndpoints);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.getOrCreateEngine());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.localEngine) {
            ServiceHelper.stopService((Object)this.engine);
        }
    }

    public PlatformHttpEngine getEngine() {
        return this.engine;
    }

    public void setEngine(PlatformHttpEngine engine) {
        this.engine = engine;
    }

    public boolean isHandleWriteResponseError() {
        return this.handleWriteResponseError;
    }

    public void setHandleWriteResponseError(boolean handleWriteResponseError) {
        this.handleWriteResponseError = handleWriteResponseError;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    private Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api, boolean register) throws Exception {
        String contextPath;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"platform-http");
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"platform-http", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        if (verb != null) {
            RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        }
        String url = RestComponentHelper.createRestConsumerUrl((String)"platform-http", (String)path, (Map)map);
        PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)camelContext.getEndpoint(url, parameters);
        endpoint.setConsumes(consumes);
        endpoint.setProduces(produces);
        DefaultPlatformHttpConsumer consumer = endpoint.createConsumer(processor);
        consumer.setRegister(register);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    PlatformHttpEngine getOrCreateEngine() {
        if (this.engine == null) {
            this.lock.lock();
            try {
                if (this.engine == null) {
                    LOG.debug("Lookup platform http engine from registry");
                    this.engine = (PlatformHttpEngine)this.getCamelContext().getRegistry().lookupByNameAndType("platform-http-engine", PlatformHttpEngine.class);
                    if (this.engine == null) {
                        LOG.debug("Lookup platform http engine from factory");
                        this.engine = (PlatformHttpEngine)this.getCamelContext().getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/").newInstance("platform-http-engine", PlatformHttpEngine.class).orElseThrow(() -> new IllegalStateException("PlatformHttpEngine is neither set on this endpoint neither found in Camel Registry or FactoryFinder."));
                        this.localEngine = true;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        CamelContextAware.trySetCamelContext((Object)this.engine, (CamelContext)this.getCamelContext());
        ServiceHelper.initService((Object)this.engine);
        return this.engine;
    }

    protected void doInit() throws Exception {
        super.doInit();
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"platform-http");
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties((Object)this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

