/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Message;
import org.apache.camel.component.platform.http.vertx.HttpRequestBodyHandler;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpSupport;
import org.apache.camel.converter.stream.CachedOutputStream;

class StreamingHttpRequestBodyHandler
extends HttpRequestBodyHandler {
    StreamingHttpRequestBodyHandler(Handler<RoutingContext> delegate) {
        super(delegate);
    }

    @Override
    void configureRoute(Route route) {
    }

    @Override
    Future<Void> handle(RoutingContext routingContext, Message message) {
        if (VertxPlatformHttpSupport.isMultiPartFormData(routingContext)) {
            return Future.failedFuture((Throwable)new IllegalStateException("Cannot process multipart/form-data requests when useStreaming=true"));
        }
        Promise promise = Promise.promise();
        HttpServerRequest request = routingContext.request();
        if (VertxPlatformHttpSupport.isFormUrlEncoded(routingContext)) {
            this.delegate.handle((Object)routingContext);
            request.endHandler(arg_0 -> ((Promise)promise).complete(arg_0));
        } else {
            CachedOutputStream stream = new CachedOutputStream(message.getExchange(), true);
            AtomicReference failureCause = new AtomicReference();
            request.handler(buffer -> {
                try {
                    stream.write(buffer.getBytes());
                }
                catch (IOException e) {
                    failureCause.set(e);
                }
            });
            request.endHandler(event -> {
                try {
                    stream.close();
                    Exception failure = (Exception)failureCause.get();
                    if (failure == null) {
                        message.setBody((Object)stream.getInputStream());
                        promise.complete();
                    } else {
                        promise.fail((Throwable)failure);
                    }
                }
                catch (IOException e) {
                    promise.fail((Throwable)e);
                }
            });
        }
        return promise.future();
    }
}

